/*
 * Decompiled with CFR 0.152.
 */
package maryk.rocksdb.util;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import maryk.ByteBufferKt;
import maryk.rocksdb.util.MemCompareKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.AbstractComparator;
import org.rocksdb.ComparatorOptions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00060\u0001j\u0002`\u0002:\u0001\u0015B\u0015\u0012\u000e\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\n\u0010\f\u001a\u00060\nj\u0002`\u000bH\u0016J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\nj\u0002`\u000bH\u0016J \u0010\u0010\u001a\u00020\u000e2\n\u0010\u0011\u001a\u00060\nj\u0002`\u000b2\n\u0010\u0012\u001a\u00060\nj\u0002`\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lmaryk/rocksdb/util/BytewiseComparator;", "Lorg/rocksdb/AbstractComparator;", "Lmaryk/rocksdb/AbstractComparator;", "copt", "Lorg/rocksdb/ComparatorOptions;", "Lmaryk/rocksdb/ComparatorOptions;", "(Lorg/rocksdb/ComparatorOptions;)V", "compare", "", "a", "Ljava/nio/ByteBuffer;", "Lmaryk/ByteBuffer;", "b", "findShortSuccessor", "", "key", "findShortestSeparator", "start", "limit", "name", "", "Companion", "rocksdb-multiplatform"})
public final class BytewiseComparator
extends AbstractComparator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public BytewiseComparator(@Nullable ComparatorOptions copt) {
        super(copt);
    }

    @NotNull
    public String name() {
        return "rocksdb.java.BytewiseComparator";
    }

    public int compare(@NotNull ByteBuffer a, @NotNull ByteBuffer b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.compare(a, b);
    }

    public void findShortestSeparator(@NotNull ByteBuffer start, @NotNull ByteBuffer limit) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)limit, (String)"limit");
        int minLength = Math.min(start.remaining(), limit.remaining());
        int diffIndex = 0;
        while (diffIndex < minLength && start.get(diffIndex) == limit.get(diffIndex)) {
            int n = diffIndex;
            diffIndex = n + 1;
        }
        if (diffIndex < minLength) {
            int limitByte;
            int startByte = start.get(diffIndex) & 0xFF;
            if (startByte >= (limitByte = limit.get(diffIndex) & 0xFF)) {
                return;
            }
            if (!(startByte < limitByte)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (diffIndex < limit.remaining() - 1 || startByte + 1 < limitByte) {
                start.put(diffIndex, (byte)((start.get(diffIndex) & 0xFF) + 1));
                start.limit(diffIndex + 1);
            } else {
                int n = diffIndex;
                diffIndex = n + 1;
                while (diffIndex < start.remaining()) {
                    if ((start.get(diffIndex) & 0xFF) < 255) {
                        start.put(diffIndex, (byte)((start.get(diffIndex) & 0xFF) + 1));
                        start.limit(diffIndex + 1);
                        break;
                    }
                    n = diffIndex;
                    diffIndex = n + 1;
                }
            }
            ByteBuffer byteBuffer = ByteBufferKt.duplicateByteBuffer(start);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicateByteBuffer(start)");
            ByteBuffer byteBuffer2 = byteBuffer;
            byteBuffer = ByteBufferKt.duplicateByteBuffer(limit);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicateByteBuffer(limit)");
            if (!(this.compare(byteBuffer2, byteBuffer) < 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public void findShortSuccessor(@NotNull ByteBuffer key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int n = key.remaining();
        int n2 = 0;
        while (n2 < n) {
            int i;
            int byt;
            if ((byt = key.get(i = n2++) & 0xFF) == 255) continue;
            key.put(i, (byte)(byt + 1));
            key.limit(i + 1);
            return;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u000e\u0010\b\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007\u00a8\u0006\t"}, d2={"Lmaryk/rocksdb/util/BytewiseComparator$Companion;", "", "()V", "compare", "", "a", "Ljava/nio/ByteBuffer;", "Lmaryk/ByteBuffer;", "b", "rocksdb-multiplatform"})
    public static final class Companion {
        private Companion() {
        }

        public final int compare(@Nullable ByteBuffer a, @Nullable ByteBuffer b) {
            if (a == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            if (b == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            int minLen = a.remaining() < b.remaining() ? a.remaining() : b.remaining();
            int r = MemCompareKt.memCompare(a, b, minLen);
            if (r == 0) {
                if (a.remaining() < b.remaining()) {
                    r = -1;
                } else if (a.remaining() > b.remaining()) {
                    r = 1;
                }
            }
            return r;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

