/*
 * Decompiled with CFR 0.152.
 */
package maryk.datastore.memory.records;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import maryk.core.models.IsRootDataModel;
import maryk.datastore.memory.processors.changers.GetValueKt;
import maryk.datastore.memory.records.DataRecord;
import maryk.datastore.memory.records.DataRecordHistoricValues;
import maryk.datastore.memory.records.DataRecordNode;
import maryk.datastore.memory.records.DataRecordValue;
import maryk.datastore.memory.records.IsDataRecordValue;
import maryk.datastore.memory.records.index.IndexValues;
import maryk.datastore.memory.records.index.UniqueIndexValues;
import maryk.datastore.shared.UniqueException;
import maryk.lib.extensions.compare.ByteArrayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JD\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0017H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJP\u0010\u001e\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0012H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J+\u0010!\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0000\u00a2\u0006\u0002\b\"J\u001d\u0010#\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\u0006\u0010$\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b%J\u001b\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010'\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b(J'\u0010)\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00120\u00112\u0006\u0010'\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b*J<\u0010+\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0017H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b,\u0010-J0\u0010.\u001a\u00020\u00142\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u0005H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b1\u00102J/\u00103\u001a\u00020\u00142\u0012\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0012052\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0000\u00a2\u0006\u0002\b6R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00120\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00067"}, d2={"Lmaryk/datastore/memory/records/DataStore;", "DM", "Lmaryk/core/models/IsRootDataModel;", "", "keepAllVersions", "", "(Z)V", "indices", "", "Lmaryk/datastore/memory/records/index/IndexValues;", "getKeepAllVersions", "()Z", "records", "Lmaryk/datastore/memory/records/DataRecord;", "getRecords", "()Ljava/util/List;", "uniqueIndices", "Lmaryk/datastore/memory/records/index/UniqueIndexValues;", "", "addToIndex", "", "record", "indexName", "", "value", "version", "Lmaryk/core/clock/HLC;", "previousValue", "addToIndex-teFcq_4$memory", "(Lmaryk/datastore/memory/records/DataRecord;[B[BJ[B)V", "addToUniqueIndex", "addToUniqueIndex-teFcq_4$memory", "(Lmaryk/datastore/memory/records/DataRecord;[BLjava/lang/Comparable;JLjava/lang/Comparable;)V", "deleteHardFromIndex", "deleteHardFromIndex$memory", "getByKey", "key", "getByKey$memory", "getOrCreateIndex", "indexReference", "getOrCreateIndex$memory", "getOrCreateUniqueIndex", "getOrCreateUniqueIndex$memory", "removeFromIndex", "removeFromIndex-_dueq8s$memory", "(Lmaryk/datastore/memory/records/DataRecord;[BJ[B)V", "removeFromUniqueIndices", "dataRecord", "hardDelete", "removeFromUniqueIndices-8AmrzUc$memory", "(Lmaryk/datastore/memory/records/DataRecord;JZ)V", "validateUniqueNotExists", "dataRecordValue", "Lmaryk/datastore/memory/records/DataRecordValue;", "validateUniqueNotExists$memory", "memory"})
@SourceDebugExtension(value={"SMAP\nDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataStore.kt\nmaryk/datastore/memory/records/DataStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1855#2,2:164\n*S KotlinDebug\n*F\n+ 1 DataStore.kt\nmaryk/datastore/memory/records/DataStore\n*L\n88#1:164,2\n*E\n"})
public final class DataStore<DM extends IsRootDataModel> {
    private final boolean keepAllVersions;
    @NotNull
    private final List<DataRecord<DM>> records;
    @NotNull
    private final List<IndexValues<DM>> indices;
    @NotNull
    private final List<UniqueIndexValues<DM, Comparable<Object>>> uniqueIndices;

    public DataStore(boolean keepAllVersions) {
        this.keepAllVersions = keepAllVersions;
        this.records = new ArrayList();
        this.indices = new ArrayList();
        this.uniqueIndices = new ArrayList();
    }

    public final boolean getKeepAllVersions() {
        return this.keepAllVersions;
    }

    @NotNull
    public final List<DataRecord<DM>> getRecords() {
        return this.records;
    }

    public final void addToIndex-teFcq_4$memory(@NotNull DataRecord<DM> record, @NotNull byte[] indexName, @NotNull byte[] value, long version, @Nullable byte[] previousValue) {
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        IndexValues<DM> index2 = this.getOrCreateIndex$memory(indexName);
        if (previousValue != null) {
            byte[] it = previousValue;
            boolean bl = false;
            index2.removeFromIndex-_dueq8s(record, previousValue, version, this.keepAllVersions);
        }
        index2.addToIndex-PQQ6geo(record, value, version);
    }

    public static /* synthetic */ void addToIndex-teFcq_4$memory$default(DataStore dataStore, DataRecord dataRecord, byte[] byArray, byte[] byArray2, long l, byte[] byArray3, int n, Object object) {
        if ((n & 0x10) != 0) {
            byArray3 = null;
        }
        dataStore.addToIndex-teFcq_4$memory(dataRecord, byArray, byArray2, l, byArray3);
    }

    public final void removeFromIndex-_dueq8s$memory(@NotNull DataRecord<DM> record, @NotNull byte[] indexName, long version, @Nullable byte[] previousValue) {
        block0: {
            Intrinsics.checkNotNullParameter(record, (String)"record");
            Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
            IndexValues<DM> index2 = this.getOrCreateIndex$memory(indexName);
            if (previousValue == null) break block0;
            byte[] it = previousValue;
            boolean bl = false;
            index2.removeFromIndex-_dueq8s(record, previousValue, version, this.keepAllVersions);
        }
    }

    public static /* synthetic */ void removeFromIndex-_dueq8s$memory$default(DataStore dataStore, DataRecord dataRecord, byte[] byArray, long l, byte[] byArray2, int n, Object object) {
        if ((n & 8) != 0) {
            byArray2 = null;
        }
        dataStore.removeFromIndex-_dueq8s$memory(dataRecord, byArray, l, byArray2);
    }

    public final void deleteHardFromIndex$memory(@NotNull byte[] indexName, @NotNull byte[] value, @NotNull DataRecord<DM> record) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(record, (String)"record");
        IndexValues<DM> index2 = this.getOrCreateIndex$memory(indexName);
        index2.deleteHardFromIndex(record, value);
    }

    public final void addToUniqueIndex-teFcq_4$memory(@NotNull DataRecord<DM> record, @NotNull byte[] indexName, @NotNull Comparable<Object> value, long version, @Nullable Comparable<Object> previousValue) {
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        UniqueIndexValues<DM, Comparable<Object>> index2 = this.getOrCreateUniqueIndex$memory(indexName);
        Comparable<Object> comparable = previousValue;
        if (comparable != null) {
            Comparable<Object> it = comparable;
            boolean bl = false;
            index2.removeFromIndex-_dueq8s(record, previousValue, version, this.keepAllVersions);
        }
        index2.addToIndex-PQQ6geo(record, value, version);
    }

    public static /* synthetic */ void addToUniqueIndex-teFcq_4$memory$default(DataStore dataStore, DataRecord dataRecord, byte[] byArray, Comparable comparable, long l, Comparable comparable2, int n, Object object) {
        if ((n & 0x10) != 0) {
            comparable2 = null;
        }
        dataStore.addToUniqueIndex-teFcq_4$memory(dataRecord, byArray, comparable, l, comparable2);
    }

    public final void removeFromUniqueIndices-8AmrzUc$memory(@NotNull DataRecord<DM> dataRecord, long version, boolean hardDelete) {
        Intrinsics.checkNotNullParameter(dataRecord, (String)"dataRecord");
        if (hardDelete) {
            for (UniqueIndexValues<DM, Comparable<Object>> indexValues : this.uniqueIndices) {
                int valueIndex2 = CollectionsKt.binarySearch$default(dataRecord.getValues(), (int)0, (int)0, (Function1)((Function1)new Function1<DataRecordNode, Integer>(indexValues){
                    final /* synthetic */ UniqueIndexValues<DM, Comparable<Object>> $indexValues;
                    {
                        this.$indexValues = $indexValues;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull DataRecordNode it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return ByteArrayKt.compareTo((byte[])it.getReference(), (byte[])this.$indexValues.getIndexReference());
                    }
                }), (int)3, null);
                if (valueIndex2 < 0) continue;
                DataRecordNode dataNode = dataRecord.getValues().get(valueIndex2);
                if (dataNode instanceof DataRecordHistoricValues) {
                    Iterable $this$forEach$iv = ((DataRecordHistoricValues)dataNode).getHistory();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IsDataRecordValue record = (IsDataRecordValue)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type maryk.datastore.memory.records.DataRecordValue<kotlin.Comparable<kotlin.Any>>");
                        indexValues.deleteHardFromIndex(dataRecord, (Comparable<Object>)((DataRecordValue)record).getValue());
                    }
                    continue;
                }
                if (!(dataNode instanceof DataRecordValue)) continue;
                indexValues.deleteHardFromIndex(dataRecord, (Comparable<Object>)((DataRecordValue)dataNode).getValue());
            }
        } else {
            for (UniqueIndexValues<DM, Comparable<Object>> indexValues : this.uniqueIndices) {
                DataRecordValue it;
                if (GetValueKt.getValue-hsU3RT8$default(dataRecord.getValues(), indexValues.getIndexReference(), null, 4, null) == null) continue;
                boolean bl = false;
                indexValues.removeFromIndex-_dueq8s(dataRecord, (Comparable<Object>)it.getValue(), version, this.keepAllVersions);
            }
        }
    }

    public final void validateUniqueNotExists$memory(@NotNull DataRecordValue<Comparable<Object>> dataRecordValue, @NotNull DataRecord<DM> dataRecord) {
        Intrinsics.checkNotNullParameter(dataRecordValue, (String)"dataRecordValue");
        Intrinsics.checkNotNullParameter(dataRecord, (String)"dataRecord");
        DataRecord dataRecord2 = this.getOrCreateUniqueIndex$memory(dataRecordValue.getReference()).get(dataRecordValue.getValue());
        if (dataRecord2 != null) {
            DataRecord it = dataRecord2;
            boolean bl = false;
            if (!Intrinsics.areEqual(it, dataRecord)) {
                throw new UniqueException(dataRecordValue.getReference(), it.getKey());
            }
        }
    }

    @NotNull
    public final IndexValues<DM> getOrCreateIndex$memory(@NotNull byte[] indexReference) {
        IndexValues<DM> indexValues;
        Intrinsics.checkNotNullParameter((Object)indexReference, (String)"indexReference");
        int i2 = CollectionsKt.binarySearch$default(this.indices, (int)0, (int)0, (Function1)new Function1<IndexValues<DM>, Integer>(indexReference){
            final /* synthetic */ byte[] $indexReference;
            {
                this.$indexReference = $indexReference;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull IndexValues<DM> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ByteArrayKt.compareTo((byte[])it.getIndexReference(), (byte[])this.$indexReference);
            }
        }, (int)3, null);
        if (i2 < 0) {
            IndexValues indexValues2;
            IndexValues it = indexValues2 = new IndexValues(indexReference);
            boolean bl = false;
            this.indices.add(i2 * -1 - 1, it);
            indexValues = indexValues2;
        } else {
            indexValues = this.indices.get(i2);
        }
        return indexValues;
    }

    @NotNull
    public final UniqueIndexValues<DM, Comparable<Object>> getOrCreateUniqueIndex$memory(@NotNull byte[] indexReference) {
        UniqueIndexValues<DM, Comparable<Object>> uniqueIndexValues;
        Intrinsics.checkNotNullParameter((Object)indexReference, (String)"indexReference");
        int i2 = CollectionsKt.binarySearch$default(this.uniqueIndices, (int)0, (int)0, (Function1)new Function1<UniqueIndexValues<DM, Comparable<? super Object>>, Integer>(indexReference){
            final /* synthetic */ byte[] $indexReference;
            {
                this.$indexReference = $indexReference;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull UniqueIndexValues<DM, Comparable<Object>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ByteArrayKt.compareTo((byte[])it.getIndexReference(), (byte[])this.$indexReference);
            }
        }, (int)3, null);
        if (i2 < 0) {
            UniqueIndexValues uniqueIndexValues2;
            UniqueIndexValues it = uniqueIndexValues2 = new UniqueIndexValues(indexReference);
            boolean bl = false;
            this.uniqueIndices.add(i2 * -1 - 1, it);
            uniqueIndexValues = uniqueIndexValues2;
        } else {
            uniqueIndexValues = this.uniqueIndices.get(i2);
        }
        return uniqueIndexValues;
    }

    @Nullable
    public final DataRecord<DM> getByKey$memory(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int index2 = CollectionsKt.binarySearch$default(this.records, (int)0, (int)0, (Function1)new Function1<DataRecord<DM>, Integer>(key){
            final /* synthetic */ byte[] $key;
            {
                this.$key = $key;
                super(1);
            }

            @NotNull
            public final Integer invoke(@NotNull DataRecord<DM> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ByteArrayKt.compareTo((byte[])it.getKey().getBytes(), (byte[])this.$key);
            }
        }, (int)3, null);
        return index2 >= 0 ? this.records.get(index2) : null;
    }
}

