/*
 * Decompiled with CFR 0.152.
 */
package maryk.datastore.memory.processors;

import kotlin.Metadata;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import maryk.core.exceptions.StorageException;
import maryk.core.properties.definitions.index.IsIndexable;
import maryk.core.values.IsValuesGetter;
import maryk.datastore.memory.processors.HistoricStoreIndexValuesGetter;
import maryk.datastore.memory.records.DataRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\n\u00a8\u0006\r"}, d2={"Lmaryk/datastore/memory/processors/HistoricStoreIndexValuesWalker;", "", "()V", "walkHistoricalValuesForIndexKeys", "", "record", "Lmaryk/datastore/memory/records/DataRecord;", "indexable", "Lmaryk/core/properties/definitions/index/IsIndexable;", "handleIndexReference", "Lkotlin/Function2;", "", "Lkotlin/ULong;", "memory"})
public final class HistoricStoreIndexValuesWalker {
    @NotNull
    public static final HistoricStoreIndexValuesWalker INSTANCE = new HistoricStoreIndexValuesWalker();

    private HistoricStoreIndexValuesWalker() {
    }

    public final void walkHistoricalValuesForIndexKeys(@NotNull DataRecord<?> record, @NotNull IsIndexable indexable, @NotNull Function2<? super byte[], ? super ULong, Unit> handleIndexReference) {
        Intrinsics.checkNotNullParameter(record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)indexable, (String)"indexable");
        Intrinsics.checkNotNullParameter(handleIndexReference, (String)"handleIndexReference");
        HistoricStoreIndexValuesGetter getter = new HistoricStoreIndexValuesGetter(record);
        ULong lastVersion = null;
        do {
            try {
                byte[] byArray = indexable.toStorageByteArrayForIndex((IsValuesGetter)getter, record.getKey().getBytes());
                if (byArray != null) {
                    byte[] historicIndexReference = byArray;
                    boolean bl = false;
                    ULong uLong = getter.getLatestOverallVersion-6VbMDqA();
                    if (uLong == null) {
                        throw new StorageException("Latest overall version not set");
                    }
                    handleIndexReference.invoke((Object)historicIndexReference, (Object)ULong.box-impl((long)uLong.unbox-impl()));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            lastVersion = getter.getVersionToSkip-6VbMDqA();
            getter.setVersionToSkip-ADd3fzo(getter.getLatestOverallVersion-6VbMDqA());
        } while (!Intrinsics.areEqual((Object)getter.getVersionToSkip-6VbMDqA(), (Object)lastVersion));
    }
}

