/*
 * Decompiled with CFR 0.152.
 */
package maryk.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import maryk.json.ExceptionWhileReadingJson;
import maryk.json.InvalidJsonContent;
import maryk.json.IsJsonLikeReader;
import maryk.json.JsonComplexType;
import maryk.json.JsonReaderKt;
import maryk.json.JsonToken;
import maryk.json.JsonWriteException;
import maryk.json.ValueType;
import maryk.lib.extensions.CharKt;
import maryk.lib.extensions.HexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0001<B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020 H\u0002J\b\u0010#\u001a\u00020\rH\u0016J\b\u0010$\u001a\u00020 H\u0002J\b\u0010%\u001a\u00020 H\u0002J-\u0010&\u001a\u00020 2#\u0010'\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u001d\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\r0(H\u0002J\b\u0010,\u001a\u00020 H\u0002J-\u0010-\u001a\u00020 2#\u0010'\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0017\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\r0(H\u0002J5\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u0002002#\u0010'\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u001d\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\r0(H\u0002J\b\u00101\u001a\u00020 H\u0002J\b\u00102\u001a\u00020\u0004H\u0002J-\u00103\u001a\u00020 2#\u0010'\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0017\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\r0(H\u0002J-\u00104\u001a\u00020 2#\u0010'\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u001d\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\r0(H\u0002J-\u00105\u001a\u00020 2#\u0010'\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u001d\u00a2\u0006\f\b)\u0012\b\b*\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\r0(H\u0002J\u001e\u00106\u001a\u00020 2\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020 \u0018\u00010(H\u0016J\b\u00108\u001a\u00020 H\u0002J\b\u00109\u001a\u00020 H\u0002J\b\u0010:\u001a\u00020 H\u0002J\b\u0010;\u001a\u00020 H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\t\"\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lmaryk/json/JsonReader;", "Lmaryk/json/IsJsonLikeReader;", "reader", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "columnNumber", "", "getColumnNumber", "()I", "setColumnNumber", "(I)V", "currentToken", "Lmaryk/json/JsonToken;", "getCurrentToken", "()Lmaryk/json/JsonToken;", "setCurrentToken", "(Lmaryk/json/JsonToken;)V", "lastChar", "lineNumber", "getLineNumber", "setLineNumber", "storedValue", "", "typeStack", "", "Lmaryk/json/JsonComplexType;", "constructJsonValueToken", "Lmaryk/json/JsonToken$Value;", "", "it", "continueComplexRead", "", "endArray", "endObject", "nextToken", "read", "readArray", "readFalse", "currentTokenCreator", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "value", "readFieldName", "readNullValue", "readNumber", "startedWithMinus", "", "readObject", "readSkipWhitespace", "readStringValue", "readTrue", "readValue", "skipUntilNextField", "handleSkipToken", "skipWhiteSpace", "startArray", "startObject", "throwJsonException", "SkipCharType", "json"})
@SourceDebugExtension(value={"SMAP\nJsonReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonReader.kt\nmaryk/json/JsonReader\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,431:1\n1174#2,2:432\n*S KotlinDebug\n*F\n+ 1 JsonReader.kt\nmaryk/json/JsonReader\n*L\n298#1:432,2\n*E\n"})
public final class JsonReader
implements IsJsonLikeReader {
    @NotNull
    private final Function0<Character> reader;
    @NotNull
    private JsonToken currentToken;
    private int columnNumber;
    private int lineNumber;
    @Nullable
    private String storedValue;
    @NotNull
    private final List<JsonComplexType> typeStack;
    private char lastChar;

    public JsonReader(@NotNull Function0<Character> reader) {
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        this.reader = reader;
        this.currentToken = JsonToken.StartDocument.INSTANCE;
        this.lineNumber = 1;
        this.storedValue = "";
        this.typeStack = new ArrayList();
        this.lastChar = (char)32;
    }

    @Override
    @NotNull
    public JsonToken getCurrentToken() {
        return this.currentToken;
    }

    @Override
    public void setCurrentToken(@NotNull JsonToken jsonToken) {
        Intrinsics.checkNotNullParameter((Object)jsonToken, (String)"<set-?>");
        this.currentToken = jsonToken;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public void setColumnNumber(int n) {
        this.columnNumber = n;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    @Override
    @NotNull
    public JsonToken nextToken() {
        this.storedValue = "";
        try {
            JsonToken jsonToken = this.getCurrentToken();
            if (Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.StartDocument.INSTANCE)) {
                this.lastChar = this.readSkipWhitespace();
                char c = this.lastChar;
                if (c == '{') {
                    this.startObject();
                } else if (c == '[') {
                    this.startArray();
                } else if (c == '\"') {
                    this.readStringValue((Function1<? super String, ? extends JsonToken>)((Function1)new Function1<Object, JsonToken.Value<? extends Object>>((Object)this){

                        @NotNull
                        public final JsonToken.Value<Object> invoke(@Nullable Object p0) {
                            return JsonReader.access$constructJsonValueToken((JsonReader)this.receiver, p0);
                        }
                    }));
                } else {
                    this.throwJsonException();
                }
            } else if (jsonToken instanceof JsonToken.StartObject) {
                this.typeStack.add(JsonComplexType.OBJECT);
                char c = this.lastChar;
                if (c == '}') {
                    this.endObject();
                } else if (c == '\"') {
                    this.readFieldName();
                } else {
                    this.throwJsonException();
                }
            } else if (Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.EndObject.INSTANCE)) {
                this.continueComplexRead();
            } else if (jsonToken instanceof JsonToken.StartArray) {
                this.typeStack.add(JsonComplexType.ARRAY);
                if (this.lastChar == ']') {
                    this.endArray();
                } else {
                    this.readValue((Function1<Object, ? extends JsonToken>)((Function1)new Function1<Object, JsonToken.Value<? extends Object>>((Object)this){

                        @NotNull
                        public final JsonToken.Value<Object> invoke(@Nullable Object p0) {
                            return JsonReader.access$constructJsonValueToken((JsonReader)this.receiver, p0);
                        }
                    }));
                }
            } else if (Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.EndArray.INSTANCE)) {
                this.continueComplexRead();
            } else if (jsonToken instanceof JsonToken.FieldName) {
                this.readValue((Function1<Object, ? extends JsonToken>)((Function1)new Function1<Object, JsonToken.Value<? extends Object>>((Object)this){

                    @NotNull
                    public final JsonToken.Value<Object> invoke(@Nullable Object p0) {
                        return JsonReader.access$constructJsonValueToken((JsonReader)this.receiver, p0);
                    }
                }));
            } else if (jsonToken instanceof JsonToken.Value) {
                if (this.typeStack.isEmpty()) {
                    this.setCurrentToken(JsonToken.EndDocument.INSTANCE);
                } else if (CollectionsKt.last(this.typeStack) == JsonComplexType.OBJECT) {
                    this.readObject();
                } else {
                    this.readArray();
                }
            } else if (Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.ObjectSeparator.INSTANCE)) {
                if (this.lastChar == '\"') {
                    this.readFieldName();
                } else {
                    this.throwJsonException();
                }
            } else if (Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.ArraySeparator.INSTANCE)) {
                this.readValue((Function1<Object, ? extends JsonToken>)((Function1)new Function1<Object, JsonToken.Value<? extends Object>>((Object)this){

                    @NotNull
                    public final JsonToken.Value<Object> invoke(@Nullable Object p0) {
                        return JsonReader.access$constructJsonValueToken((JsonReader)this.receiver, p0);
                    }
                }));
            } else {
                if (jsonToken instanceof JsonToken.Suspended) {
                    JsonToken jsonToken2 = this.getCurrentToken();
                    Intrinsics.checkNotNull((Object)jsonToken2, (String)"null cannot be cast to non-null type maryk.json.JsonToken.Suspended");
                    JsonToken.Suspended it = (JsonToken.Suspended)jsonToken2;
                    boolean bl = false;
                    this.setCurrentToken(it.getLastToken());
                    this.storedValue = it.getStoredValue();
                    this.readSkipWhitespace();
                    return this.nextToken();
                }
                if (jsonToken instanceof JsonToken.Stopped) {
                    return this.getCurrentToken();
                }
                if (Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.StartComplexFieldName.INSTANCE) ? true : Intrinsics.areEqual((Object)jsonToken, (Object)JsonToken.EndComplexFieldName.INSTANCE)) {
                    throw new JsonWriteException("Start and End ComplexFieldName not possible in JSON");
                }
            }
        }
        catch (ExceptionWhileReadingJson e) {
            this.setCurrentToken(new JsonToken.Suspended(this.getCurrentToken(), this.storedValue));
        }
        catch (InvalidJsonContent e) {
            this.setCurrentToken(new JsonToken.JsonException(e));
            e.setColumnNumber(this.getColumnNumber());
            e.setLineNumber(this.getLineNumber());
            throw e;
        }
        if (ArraysKt.contains((Object[])JsonReaderKt.access$getSkipArray$p(), (Object)this.getCurrentToken())) {
            return this.nextToken();
        }
        return this.getCurrentToken();
    }

    private final JsonToken.Value<Object> constructJsonValueToken(Object it) {
        Object object = it;
        return object == null ? (JsonToken.Value<Object>)JsonToken.NullValue.INSTANCE : (object instanceof Boolean ? new JsonToken.Value<Object>(it, ValueType.Bool.INSTANCE) : (object instanceof String ? new JsonToken.Value<Object>(it, ValueType.String.INSTANCE) : (object instanceof Double ? new JsonToken.Value<Object>(it, ValueType.Float.INSTANCE) : (object instanceof Long ? new JsonToken.Value<Object>(it, ValueType.Int.INSTANCE) : new JsonToken.Value<String>(it.toString(), ValueType.String.INSTANCE)))));
    }

    @Override
    public void skipUntilNextField(@Nullable Function1<? super JsonToken, Unit> handleSkipToken) {
        int startDepth = ((Collection)this.typeStack).size();
        this.nextToken();
        while (!(this.getCurrentToken() instanceof JsonToken.FieldName && ((Collection)this.typeStack).size() <= startDepth || this.getCurrentToken() instanceof JsonToken.EndObject && ((Collection)this.typeStack).size() < startDepth || this.getCurrentToken() instanceof JsonToken.Stopped)) {
            Function1<? super JsonToken, Unit> function1 = handleSkipToken;
            if (function1 != null) {
                function1.invoke((Object)this.getCurrentToken());
            }
            this.nextToken();
        }
    }

    private final void read() {
        try {
            this.lastChar = ((Character)this.reader.invoke()).charValue();
            if (CharKt.isLineBreak((char)this.lastChar)) {
                this.setLineNumber(this.getLineNumber() + 1);
                this.setColumnNumber(0);
            } else {
                this.setColumnNumber(this.getColumnNumber() + 1);
            }
        }
        catch (Throwable e) {
            throw new ExceptionWhileReadingJson();
        }
    }

    private final char readSkipWhitespace() {
        this.read();
        this.skipWhiteSpace();
        return this.lastChar;
    }

    private final void skipWhiteSpace() {
        if (CharsKt.isWhitespace((char)this.lastChar)) {
            this.readSkipWhitespace();
        }
    }

    private final void continueComplexRead() {
        if (this.typeStack.isEmpty()) {
            this.setCurrentToken(JsonToken.EndDocument.INSTANCE);
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[((JsonComplexType)((Object)CollectionsKt.last(this.typeStack))).ordinal()]) {
                case 1: {
                    this.readObject();
                    break;
                }
                case 2: {
                    this.readArray();
                }
            }
        }
    }

    private final void readArray() {
        char c = this.lastChar;
        if (c == ',') {
            this.setCurrentToken(JsonToken.ArraySeparator.INSTANCE);
            this.readSkipWhitespace();
        } else if (c == ']') {
            this.endArray();
        } else {
            this.throwJsonException();
        }
    }

    private final void readObject() {
        char c = this.lastChar;
        if (c == ',') {
            this.setCurrentToken(JsonToken.ObjectSeparator.INSTANCE);
            this.readSkipWhitespace();
        } else if (c == '}') {
            this.endObject();
        } else {
            this.throwJsonException();
        }
    }

    private final void readValue(Function1<Object, ? extends JsonToken> currentTokenCreator) {
        char c = this.lastChar;
        if (c == '{') {
            this.startObject();
        } else if (c == '[') {
            this.startArray();
        } else if (c == '\"') {
            this.readStringValue(currentTokenCreator);
        } else if (c == '-') {
            this.readNumber(true, currentTokenCreator);
        } else if (c == 'n') {
            this.readNullValue(currentTokenCreator);
        } else if (c == 't') {
            this.readTrue(currentTokenCreator);
        } else if (c == 'f') {
            this.readFalse(currentTokenCreator);
        } else if (Character.isDigit(this.lastChar)) {
            this.readNumber(false, currentTokenCreator);
        } else {
            this.throwJsonException();
        }
    }

    private final void readNumber(boolean startedWithMinus, Function1<Object, ? extends JsonToken> currentTokenCreator) {
        JsonToken jsonToken;
        boolean isExponent;
        boolean bl;
        do {
            JsonReader.readNumber$addAndAdvance(this);
        } while (Character.isDigit(this.lastChar));
        String string = this.storedValue;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            if (startedWithMinus && it.length() > 2 && it.charAt(1) == '0') {
                this.throwJsonException();
            } else if (it.length() > 1 && it.charAt(0) == '0') {
                this.throwJsonException();
            }
        }
        if (this.lastChar == '.') {
            JsonReader.readNumber$addAndAdvance(this);
            if (!Character.isDigit(this.lastChar)) {
                this.throwJsonException();
            }
            do {
                JsonReader.readNumber$addAndAdvance(this);
            } while (Character.isDigit(this.lastChar));
            bl = true;
        } else {
            bl = false;
        }
        boolean isFraction = bl;
        Object[] objectArray = new Character[]{Character.valueOf('e'), Character.valueOf('E')};
        if (ArraysKt.contains((Object[])objectArray, (Object)Character.valueOf(this.lastChar))) {
            JsonReader.readNumber$addAndAdvance(this);
            objectArray = new Character[]{Character.valueOf('+'), Character.valueOf('-')};
            if (ArraysKt.contains((Object[])objectArray, (Object)Character.valueOf(this.lastChar))) {
                JsonReader.readNumber$addAndAdvance(this);
            }
            if (!Character.isDigit(this.lastChar)) {
                this.throwJsonException();
            }
            do {
                JsonReader.readNumber$addAndAdvance(this);
            } while (Character.isDigit(this.lastChar));
            v2 = true;
        } else {
            v2 = isExponent = false;
        }
        if (isExponent || isFraction) {
            String string2 = this.storedValue;
            Intrinsics.checkNotNull((Object)string2);
            jsonToken = (JsonToken)currentTokenCreator.invoke((Object)Double.parseDouble(string2));
        } else {
            String string3 = this.storedValue;
            Intrinsics.checkNotNull((Object)string3);
            jsonToken = (JsonToken)currentTokenCreator.invoke((Object)Long.parseLong(string3));
        }
        this.setCurrentToken(jsonToken);
        this.skipWhiteSpace();
    }

    private final void readFalse(Function1<Object, ? extends JsonToken> currentTokenCreator) {
        int n = "alse".length();
        for (int i = 0; i < n; ++i) {
            char it = "alse".charAt(i);
            this.read();
            if (this.lastChar == it) continue;
            this.throwJsonException();
        }
        this.setCurrentToken((JsonToken)currentTokenCreator.invoke((Object)false));
        this.readSkipWhitespace();
    }

    private final void readTrue(Function1<Object, ? extends JsonToken> currentTokenCreator) {
        CharSequence $this$forEach$iv = "rue";
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            this.read();
            if (this.lastChar == it) continue;
            this.throwJsonException();
        }
        this.setCurrentToken((JsonToken)currentTokenCreator.invoke((Object)true));
        this.readSkipWhitespace();
    }

    private final void readNullValue(Function1<? super String, ? extends JsonToken> currentTokenCreator) {
        int n = "ull".length();
        for (int i = 0; i < n; ++i) {
            char it = "ull".charAt(i);
            this.read();
            if (this.lastChar == it) continue;
            this.throwJsonException();
        }
        this.storedValue = null;
        this.setCurrentToken((JsonToken)currentTokenCreator.invoke(null));
        this.readSkipWhitespace();
    }

    private final void readFieldName() {
        this.readStringValue((Function1<? super String, ? extends JsonToken>)((Function1)new Function1<String, JsonToken>(this){
            final /* synthetic */ JsonReader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final JsonToken invoke(@Nullable String it) {
                return new JsonToken.FieldName(JsonReader.access$getStoredValue$p(this.this$0));
            }
        }));
        if (this.lastChar != ':') {
            this.throwJsonException();
        }
        this.readSkipWhitespace();
    }

    private final void readStringValue(Function1<? super String, ? extends JsonToken> currentTokenCreator) {
        this.read();
        SkipCharType skipChar = SkipCharType.None.INSTANCE;
        while (this.lastChar != '\"' || Intrinsics.areEqual((Object)skipChar, (Object)SkipCharType.StartNewEscaped.INSTANCE)) {
            SkipCharType skipCharType;
            SkipCharType skipCharType2 = skipChar;
            if (Intrinsics.areEqual((Object)skipCharType2, (Object)SkipCharType.None.INSTANCE)) {
                skipCharType = this.lastChar == '\\' ? (SkipCharType)SkipCharType.StartNewEscaped.INSTANCE : JsonReader.readStringValue$addCharAndResetSkipChar(this, String.valueOf(this.lastChar));
            } else if (Intrinsics.areEqual((Object)skipCharType2, (Object)SkipCharType.StartNewEscaped.INSTANCE)) {
                var4_4 = this.lastChar;
                skipCharType = var4_4 == 'b' ? JsonReader.readStringValue$addCharAndResetSkipChar(this, "\b") : (var4_4 == '\"' ? JsonReader.readStringValue$addCharAndResetSkipChar(this, "\"") : (var4_4 == '\\' ? JsonReader.readStringValue$addCharAndResetSkipChar(this, "\\") : (var4_4 == '/' ? JsonReader.readStringValue$addCharAndResetSkipChar(this, "/") : (var4_4 == 'f' ? JsonReader.readStringValue$addCharAndResetSkipChar(this, "\f") : (var4_4 == 'n' ? JsonReader.readStringValue$addCharAndResetSkipChar(this, "\n") : (var4_4 == 'r' ? JsonReader.readStringValue$addCharAndResetSkipChar(this, "\r") : (var4_4 == 't' ? JsonReader.readStringValue$addCharAndResetSkipChar(this, "\t") : (var4_4 == 'u' ? (SkipCharType)new SkipCharType.UtfChar('u', 4) : JsonReader.readStringValue$addCharAndResetSkipChar(this, "\\" + this.lastChar)))))))));
            } else if (skipCharType2 instanceof SkipCharType.UtfChar) {
                var4_4 = Character.toLowerCase(this.lastChar);
                skipCharType = ArraysKt.contains((char[])HexKt.getHEX_CHARS(), (char)var4_4) ? (((SkipCharType.UtfChar)skipChar).addCharAndHasReachedEnd(this.lastChar) ? JsonReader.readStringValue$addCharAndResetSkipChar(this, ((SkipCharType.UtfChar)skipChar).toCharString()) : skipChar) : JsonReader.readStringValue$addCharAndResetSkipChar(this, "\\" + ((SkipCharType.UtfChar)skipChar).getCharType() + ((SkipCharType.UtfChar)skipChar).toOriginalChars() + this.lastChar);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            skipChar = skipCharType;
            this.read();
        }
        this.setCurrentToken((JsonToken)currentTokenCreator.invoke((Object)this.storedValue));
        if (!((Collection)this.typeStack).isEmpty()) {
            this.readSkipWhitespace();
        }
    }

    private final void startObject() {
        this.setCurrentToken(JsonToken.SimpleStartObject.INSTANCE);
        this.readSkipWhitespace();
    }

    private final void endObject() {
        this.typeStack.remove(CollectionsKt.getLastIndex(this.typeStack));
        this.setCurrentToken(JsonToken.EndObject.INSTANCE);
        if (!((Collection)this.typeStack).isEmpty()) {
            this.readSkipWhitespace();
        }
    }

    private final void startArray() {
        this.setCurrentToken(JsonToken.SimpleStartArray.INSTANCE);
        this.readSkipWhitespace();
    }

    private final void endArray() {
        this.typeStack.remove(CollectionsKt.getLastIndex(this.typeStack));
        this.setCurrentToken(JsonToken.EndArray.INSTANCE);
        if (!((Collection)this.typeStack).isEmpty()) {
            this.readSkipWhitespace();
        }
    }

    private final void throwJsonException() {
        throw new InvalidJsonContent("Invalid character '" + this.lastChar + "' after " + this.getCurrentToken());
    }

    private static final void readNumber$addAndAdvance(JsonReader this$0) {
        this$0.storedValue = this$0.storedValue + this$0.lastChar;
        this$0.read();
    }

    private static final SkipCharType readStringValue$addCharAndResetSkipChar(JsonReader this$0, String value) {
        this$0.storedValue = this$0.storedValue + value;
        return SkipCharType.None.INSTANCE;
    }

    public static final /* synthetic */ JsonToken.Value access$constructJsonValueToken(JsonReader $this, Object it) {
        return $this.constructJsonValueToken(it);
    }

    public static final /* synthetic */ String access$getStoredValue$p(JsonReader $this) {
        return $this.storedValue;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lmaryk/json/JsonReader$SkipCharType;", "", "()V", "None", "StartNewEscaped", "UtfChar", "Lmaryk/json/JsonReader$SkipCharType$None;", "Lmaryk/json/JsonReader$SkipCharType$StartNewEscaped;", "Lmaryk/json/JsonReader$SkipCharType$UtfChar;", "json"})
    private static abstract class SkipCharType {
        private SkipCharType() {
        }

        public /* synthetic */ SkipCharType(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lmaryk/json/JsonReader$SkipCharType$None;", "Lmaryk/json/JsonReader$SkipCharType;", "()V", "json"})
        public static final class None
        extends SkipCharType {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lmaryk/json/JsonReader$SkipCharType$StartNewEscaped;", "Lmaryk/json/JsonReader$SkipCharType;", "()V", "json"})
        public static final class StartNewEscaped
        extends SkipCharType {
            @NotNull
            public static final StartNewEscaped INSTANCE = new StartNewEscaped();

            private StartNewEscaped() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmaryk/json/JsonReader$SkipCharType$UtfChar;", "Lmaryk/json/JsonReader$SkipCharType;", "charType", "", "charCount", "", "(CI)V", "getCharType", "()C", "chars", "", "getChars", "()[C", "setChars", "([C)V", "index", "addCharAndHasReachedEnd", "", "char", "toCharString", "", "toOriginalChars", "json"})
        public static class UtfChar
        extends SkipCharType {
            private final char charType;
            private final int charCount;
            @NotNull
            private char[] chars;
            private int index;

            public UtfChar(char charType, int charCount) {
                super(null);
                this.charType = charType;
                this.charCount = charCount;
                this.chars = new char[this.charCount];
            }

            public final char getCharType() {
                return this.charType;
            }

            @NotNull
            protected final char[] getChars() {
                return this.chars;
            }

            protected final void setChars(@NotNull char[] cArray) {
                Intrinsics.checkNotNullParameter((Object)cArray, (String)"<set-?>");
                this.chars = cArray;
            }

            public final boolean addCharAndHasReachedEnd(char c) {
                int n = this.index;
                this.index = n + 1;
                this.chars[n] = c;
                return this.index == this.charCount;
            }

            @NotNull
            public String toCharString() {
                return String.valueOf((char)Integer.parseInt(ArraysKt.joinToString$default((char[])this.chars, (CharSequence)"", null, null, (int)0, null, null, (int)62, null), CharsKt.checkRadix((int)16)));
            }

            @NotNull
            public final String toOriginalChars() {
                return ArraysKt.joinToString$default((char[])ArraysKt.sliceArray((char[])this.chars, (IntRange)RangesKt.until((int)0, (int)this.index)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonComplexType.values().length];
            try {
                nArray[JsonComplexType.OBJECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonComplexType.ARRAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

