/*
 * Decompiled with CFR 0.152.
 */
package maryk.json;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import maryk.json.IllegalJsonOperation;
import maryk.json.IsJsonLikeWriter;
import maryk.json.JsonEmbedType;
import maryk.json.JsonType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0004J\b\u0010\u0012\u001a\u00020\u0011H\u0004J#\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0004\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lmaryk/json/AbstractJsonLikeWriter;", "Lmaryk/json/IsJsonLikeWriter;", "()V", "lastType", "Lmaryk/json/JsonType;", "getLastType", "()Lmaryk/json/JsonType;", "setLastType", "(Lmaryk/json/JsonType;)V", "typeStack", "", "Lmaryk/json/JsonEmbedType;", "getTypeStack", "()Ljava/util/List;", "setTypeStack", "(Ljava/util/List;)V", "checkArrayValueAllowed", "", "checkObjectValueAllowed", "checkTypeIsAllowed", "type", "allowed", "", "(Lmaryk/json/JsonType;[Lmaryk/json/JsonType;)V", "writeEndArray", "writeEndObject", "writeFieldName", "name", "", "writeStartArray", "isCompact", "", "writeStartObject", "json"})
public abstract class AbstractJsonLikeWriter
implements IsJsonLikeWriter {
    @NotNull
    private JsonType lastType = JsonType.START;
    @NotNull
    private List<JsonEmbedType> typeStack = new ArrayList();

    @NotNull
    protected final JsonType getLastType() {
        return this.lastType;
    }

    protected final void setLastType(@NotNull JsonType jsonType) {
        Intrinsics.checkNotNullParameter((Object)((Object)jsonType), (String)"<set-?>");
        this.lastType = jsonType;
    }

    @NotNull
    protected final List<JsonEmbedType> getTypeStack() {
        return this.typeStack;
    }

    protected final void setTypeStack(@NotNull List<JsonEmbedType> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.typeStack = list;
    }

    @Override
    public void writeStartObject(boolean isCompact) {
        this.typeStack.add(new JsonEmbedType.Object(isCompact));
        JsonType[] jsonTypeArray = new JsonType[]{JsonType.START, JsonType.FIELD_NAME, JsonType.ARRAY_VALUE, JsonType.START_ARRAY, JsonType.END_OBJ, JsonType.TAG, JsonType.COMPLEX_FIELD_NAME_START, JsonType.COMPLEX_FIELD_NAME_END};
        this.checkTypeIsAllowed(JsonType.START_OBJ, jsonTypeArray);
    }

    @Override
    public void writeEndObject() {
        if (this.typeStack.isEmpty() || !(CollectionsKt.last(this.typeStack) instanceof JsonEmbedType.Object)) {
            throw new IllegalJsonOperation("There is no object to close");
        }
        this.typeStack.remove(CollectionsKt.getLastIndex(this.typeStack));
        JsonType[] jsonTypeArray = new JsonType[]{JsonType.START_OBJ, JsonType.OBJ_VALUE, JsonType.END_OBJ, JsonType.END_ARRAY};
        this.checkTypeIsAllowed(JsonType.END_OBJ, jsonTypeArray);
    }

    @Override
    public void writeStartArray(boolean isCompact) {
        this.typeStack.add(new JsonEmbedType.Array(isCompact));
        JsonType[] jsonTypeArray = new JsonType[]{JsonType.START, JsonType.FIELD_NAME, JsonType.START_ARRAY, JsonType.ARRAY_VALUE, JsonType.END_ARRAY, JsonType.TAG, JsonType.COMPLEX_FIELD_NAME_START, JsonType.COMPLEX_FIELD_NAME_END};
        this.checkTypeIsAllowed(JsonType.START_ARRAY, jsonTypeArray);
    }

    @Override
    public void writeEndArray() {
        if (this.typeStack.isEmpty() || !(CollectionsKt.last(this.typeStack) instanceof JsonEmbedType.Array)) {
            throw new IllegalJsonOperation("Json: There is no array to close");
        }
        this.typeStack.remove(CollectionsKt.getLastIndex(this.typeStack));
        JsonType[] jsonTypeArray = new JsonType[]{JsonType.START_ARRAY, JsonType.ARRAY_VALUE, JsonType.END_ARRAY, JsonType.END_OBJ, JsonType.TAG};
        this.checkTypeIsAllowed(JsonType.END_ARRAY, jsonTypeArray);
    }

    @Override
    public void writeFieldName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        JsonType[] jsonTypeArray = new JsonType[]{JsonType.START_OBJ, JsonType.OBJ_VALUE, JsonType.END_ARRAY, JsonType.END_OBJ};
        this.checkTypeIsAllowed(JsonType.FIELD_NAME, jsonTypeArray);
    }

    protected final void checkTypeIsAllowed(@NotNull JsonType type, @NotNull JsonType[] allowed) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)allowed, (String)"allowed");
        if (!ArraysKt.contains((Object[])allowed, (Object)((Object)this.lastType))) {
            throw new IllegalJsonOperation("Type " + type + " not allowed after " + this.lastType);
        }
        this.lastType = type;
    }

    protected final void checkObjectValueAllowed() {
        JsonType[] jsonTypeArray = new JsonType[]{JsonType.FIELD_NAME, JsonType.TAG, JsonType.COMPLEX_FIELD_NAME_END};
        this.checkTypeIsAllowed(JsonType.OBJ_VALUE, jsonTypeArray);
    }

    protected final void checkArrayValueAllowed() {
        JsonType[] jsonTypeArray = new JsonType[]{JsonType.START_ARRAY, JsonType.ARRAY_VALUE, JsonType.TAG, JsonType.END_OBJ, JsonType.END_ARRAY};
        this.checkTypeIsAllowed(JsonType.ARRAY_VALUE, jsonTypeArray);
    }

    @Override
    public void writeBoolean(boolean bl) {
        IsJsonLikeWriter.DefaultImpls.writeBoolean(this, bl);
    }

    @Override
    public void writeInt(int n) {
        IsJsonLikeWriter.DefaultImpls.writeInt(this, n);
    }

    @Override
    public void writeFloat(float f) {
        IsJsonLikeWriter.DefaultImpls.writeFloat(this, f);
    }

    @Override
    public void writeNull() {
        IsJsonLikeWriter.DefaultImpls.writeNull(this);
    }
}

