/*
 * Decompiled with CFR 0.152.
 */
package maryk.json;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import maryk.json.AbstractJsonLikeWriter;
import maryk.json.JsonEmbedType;
import maryk.json.JsonType;
import maryk.json.JsonWriteException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lmaryk/json/JsonWriter;", "Lmaryk/json/AbstractJsonLikeWriter;", "pretty", "", "writer", "Lkotlin/Function1;", "", "", "(ZLkotlin/jvm/functions/Function1;)V", "makePretty", "writeEndArray", "writeEndObject", "writeFieldName", "name", "writeStartArray", "isCompact", "writeStartObject", "writeString", "value", "writeValue", "json"})
public final class JsonWriter
extends AbstractJsonLikeWriter {
    private final boolean pretty;
    @NotNull
    private final Function1<String, Unit> writer;

    public JsonWriter(boolean pretty, @NotNull Function1<? super String, Unit> writer) {
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        this.pretty = pretty;
        this.writer = writer;
    }

    public /* synthetic */ JsonWriter(boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl, (Function1<? super String, Unit>)function1);
    }

    @Override
    public void writeStartObject(boolean isCompact) {
        if (this.getLastType() != JsonType.START_ARRAY && !((Collection)this.getTypeStack()).isEmpty() && CollectionsKt.last(this.getTypeStack()) instanceof JsonEmbedType.Array) {
            this.writer.invoke((Object)",");
            if (this.pretty) {
                this.writer.invoke((Object)" ");
            }
        }
        super.writeStartObject(isCompact);
        this.writer.invoke((Object)"{");
        this.makePretty();
    }

    @Override
    public void writeEndObject() {
        super.writeEndObject();
        this.makePretty();
        this.writer.invoke((Object)"}");
    }

    @Override
    public void writeStartArray(boolean isCompact) {
        if (this.getLastType() != JsonType.START_ARRAY && !((Collection)this.getTypeStack()).isEmpty() && CollectionsKt.last(this.getTypeStack()) instanceof JsonEmbedType.Array) {
            this.writer.invoke((Object)",");
            if (this.pretty) {
                this.writer.invoke((Object)" ");
            }
        }
        super.writeStartArray(isCompact);
        this.writer.invoke((Object)"[");
    }

    @Override
    public void writeEndArray() {
        super.writeEndArray();
        this.writer.invoke((Object)"]");
    }

    @Override
    public void writeFieldName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.getLastType() != JsonType.START_OBJ) {
            this.writer.invoke((Object)",");
            this.makePretty();
        }
        super.writeFieldName(name);
        this.writer.invoke((Object)("\"" + name + "\":"));
        if (this.pretty) {
            this.writer.invoke((Object)" ");
        }
    }

    @Override
    public void writeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writeValue("\"" + value + "\"");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(!((Collection)this.getTypeStack()).isEmpty())) {
            this.writer.invoke((Object)value);
            return;
        }
        JsonEmbedType jsonEmbedType = (JsonEmbedType)CollectionsKt.last(this.getTypeStack());
        if (jsonEmbedType instanceof JsonEmbedType.Object) {
            super.checkObjectValueAllowed();
            this.writer.invoke((Object)value);
            return;
        }
        if (!(jsonEmbedType instanceof JsonEmbedType.Array)) {
            if (!(jsonEmbedType instanceof JsonEmbedType.ComplexField)) throw new NoWhenBranchMatchedException();
            throw new JsonWriteException("Complex fields are not possible in JSON");
        }
        if (this.getLastType() != JsonType.START_ARRAY) {
            this.writer.invoke((Object)",");
            if (this.pretty) {
                this.writer.invoke((Object)" ");
            }
        }
        super.checkArrayValueAllowed();
        this.writer.invoke((Object)value);
    }

    private final void makePretty() {
        if (this.pretty) {
            this.writer.invoke((Object)"\n");
            for (JsonEmbedType it : this.getTypeStack()) {
                if (!(it instanceof JsonEmbedType.Object)) continue;
                this.writer.invoke((Object)"  ");
            }
        }
    }
}

