/*
 * Decompiled with CFR 0.152.
 */
package maryk.core.properties.types.numeric;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import maryk.core.extensions.bytes.DoubleKt;
import maryk.core.properties.types.numeric.NumberDescriptor;
import maryk.core.properties.types.numeric.NumberType;
import maryk.core.protobuf.WireType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0010\u00a2\u0006\u0002\b\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019J\u0017\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002H\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0005H\u0010\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0010\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020(H\u0010\u00a2\u0006\u0004\b)\u0010*J\u001d\u0010+\u001a\u00020\u00022\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0010\u00a2\u0006\u0004\b,\u0010-J\u001d\u0010.\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010/\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0010\u00a2\u0006\u0002\b0J8\u00101\u001a\u0002022\u0006\u0010\u0006\u001a\u00020\u00022!\u00103\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b5\u0012\b\b6\u0012\u0004\b\b(7\u0012\u0004\u0012\u00020204H\u0010\u00a2\u0006\u0002\b8J8\u00109\u001a\u0002022\u0006\u0010\u0006\u001a\u00020\u00022!\u00103\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b5\u0012\b\b6\u0012\u0004\b\b(7\u0012\u0004\u0012\u00020204H\u0010\u00a2\u0006\u0002\b:\u00a8\u0006;"}, d2={"Lmaryk/core/properties/types/numeric/Float64;", "Lmaryk/core/properties/types/numeric/NumberDescriptor;", "", "()V", "calculateTransportByteLength", "", "value", "calculateTransportByteLength$core", "createRandom", "createRandom$core", "()Ljava/lang/Double;", "divide", "value1", "value2", "(DD)Ljava/lang/Double;", "fromStorageByteReader", "length", "reader", "Lkotlin/Function0;", "", "fromStorageByteReader$core", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Double;", "isOfType", "", "", "isOfType$core", "ofDouble", "double", "ofDouble$core", "(D)Ljava/lang/Double;", "ofInt", "int", "ofInt$core", "(I)Ljava/lang/Double;", "ofLong", "long", "", "ofLong$core", "(J)Ljava/lang/Double;", "ofString", "", "ofString$core", "(Ljava/lang/String;)Ljava/lang/Double;", "readTransportBytes", "readTransportBytes$core", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Double;", "sum", "toDouble", "toDouble$core", "writeStorageBytes", "", "writer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "byte", "writeStorageBytes$core", "writeTransportBytes", "writeTransportBytes$core", "core"})
public final class Float64
extends NumberDescriptor<Double> {
    @NotNull
    public static final Float64 INSTANCE = new Float64();

    private Float64() {
        super(8, WireType.BIT_64, NumberType.Float64Type.INSTANCE, 0.0);
    }

    @Override
    @NotNull
    public Double sum(double value1, double value2) {
        return value1 + value2;
    }

    @Override
    @NotNull
    public Double divide(double value1, double value2) {
        return value1 / value2;
    }

    @Override
    @NotNull
    public Double fromStorageByteReader$core(int length, @NotNull Function0<Byte> reader2) {
        Intrinsics.checkNotNullParameter(reader2, (String)"reader");
        return DoubleKt.initDouble(reader2);
    }

    @Override
    public void writeStorageBytes$core(double value2, @NotNull Function1<? super Byte, Unit> writer2) {
        Intrinsics.checkNotNullParameter(writer2, (String)"writer");
        DoubleKt.writeBytes(value2, writer2);
    }

    @Override
    @NotNull
    public Double readTransportBytes$core(@NotNull Function0<Byte> reader2) {
        Intrinsics.checkNotNullParameter(reader2, (String)"reader");
        return DoubleKt.initDoubleFromTransport(reader2);
    }

    @Override
    public int calculateTransportByteLength$core(double value2) {
        return this.getSize$core();
    }

    @Override
    public void writeTransportBytes$core(double value2, @NotNull Function1<? super Byte, Unit> writer2) {
        Intrinsics.checkNotNullParameter(writer2, (String)"writer");
        DoubleKt.writeTransportableBytes(value2, writer2);
    }

    @Override
    @NotNull
    public Double ofString$core(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return Double.parseDouble(value2);
    }

    @Override
    @NotNull
    public Double ofDouble$core(double d) {
        return d;
    }

    @Override
    public double toDouble$core(double value2) {
        return value2;
    }

    @Override
    @NotNull
    public Double ofInt$core(int n) {
        return n;
    }

    @Override
    @NotNull
    public Double ofLong$core(long l) {
        return l;
    }

    @Override
    @NotNull
    public Double createRandom$core() {
        return Random.Default.nextDouble();
    }

    @Override
    public boolean isOfType$core(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return value2 instanceof Double;
    }
}

