/*
 * Decompiled with CFR 0.152.
 */
package maryk.core.properties.types;

import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import maryk.core.properties.types.GeoPointKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u0012\u0006\u0010\u0004\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00062\b\b\u0002\u0010\u0004\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0018"}, d2={"Lmaryk/core/properties/types/GeoPoint;", "", "latitude", "", "longitude", "(II)V", "", "(DD)V", "getLatitude", "()D", "getLongitude", "asLong", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "latitudeAsInt", "longitudeAsInt", "toString", "", "core"})
@SourceDebugExtension(value={"SMAP\nGeoPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoPoint.kt\nmaryk/core/properties/types/GeoPoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class GeoPoint {
    private final double latitude;
    private final double longitude;

    public GeoPoint(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        if (!(this.latitude >= -90.0)) {
            boolean $i$a$-require-GeoPoint$52 = false;
            String $i$a$-require-GeoPoint$52 = "Latitude " + this.latitude + " needs to be bigger or equal to -90";
            throw new IllegalArgumentException($i$a$-require-GeoPoint$52.toString());
        }
        if (!(this.latitude <= 90.0)) {
            boolean $i$a$-require-GeoPoint$62 = false;
            String $i$a$-require-GeoPoint$62 = "Latitude " + this.latitude + " needs to be smaller or equal to 90";
            throw new IllegalArgumentException($i$a$-require-GeoPoint$62.toString());
        }
        if (!(this.longitude >= -180.0)) {
            boolean $i$a$-require-GeoPoint$72 = false;
            String $i$a$-require-GeoPoint$72 = "Longitude " + this.latitude + " needs to be smaller or equal to -180";
            throw new IllegalArgumentException($i$a$-require-GeoPoint$72.toString());
        }
        if (!(this.longitude <= 180.0)) {
            boolean bl = false;
            String string2 = "Longitude " + this.latitude + " needs to be smaller or equal to 180";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public GeoPoint(int latitude, int longitude) {
        this(GeoPointKt.access$convertLatitude(latitude), GeoPointKt.access$convertLongitude(longitude));
    }

    public final int latitudeAsInt() {
        return MathKt.roundToInt((double)(this.latitude * (double)10000000));
    }

    public final int longitudeAsInt() {
        return MathKt.roundToInt((double)(this.longitude * (double)10000000));
    }

    public final long asLong() {
        return ULong.constructor-impl((long)(ULong.constructor-impl((long)(ULong.constructor-impl((long)this.latitudeAsInt()) << 32)) + ULong.constructor-impl((long)((long)UInt.constructor-impl((int)this.longitudeAsInt()) & 0xFFFFFFFFL))));
    }

    @NotNull
    public String toString() {
        return this.latitude + "," + this.longitude;
    }

    public final double component1() {
        return this.latitude;
    }

    public final double component2() {
        return this.longitude;
    }

    @NotNull
    public final GeoPoint copy(double latitude, double longitude) {
        return new GeoPoint(latitude, longitude);
    }

    public static /* synthetic */ GeoPoint copy$default(GeoPoint geoPoint2, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = geoPoint2.latitude;
        }
        if ((n & 2) != 0) {
            d2 = geoPoint2.longitude;
        }
        return geoPoint2.copy(d, d2);
    }

    public int hashCode() {
        int result = Double.hashCode(this.latitude);
        result = result * 31 + Double.hashCode(this.longitude);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GeoPoint)) {
            return false;
        }
        GeoPoint geoPoint2 = (GeoPoint)other;
        if (Double.compare(this.latitude, geoPoint2.latitude) != 0) {
            return false;
        }
        return Double.compare(this.longitude, geoPoint2.longitude) == 0;
    }
}

