/*
 * Decompiled with CFR 0.152.
 */
package maryk.core.properties.types;

import java.time.Month;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import maryk.core.exceptions.TypeException;
import maryk.core.properties.definitions.TimeDefinition;
import maryk.core.properties.types.DateUnit;
import maryk.lib.exceptions.ParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0000\u001a\u0002H\u0001\"\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u0002*\u0002H\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u001a\u0012\u0010\u0000\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0000\u001a\u00020\b*\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"roundToDateUnit", "T", "", "dateUnit", "Lmaryk/core/properties/types/DateUnit;", "(Ljava/lang/Comparable;Lmaryk/core/properties/types/DateUnit;)Ljava/lang/Comparable;", "Lkotlinx/datetime/LocalDate;", "Lkotlinx/datetime/LocalDateTime;", "Lkotlinx/datetime/LocalTime;", "core"})
public final class DateUnitKt {
    @NotNull
    public static final <T extends Comparable<?>> T roundToDateUnit(@NotNull T $this$roundToDateUnit, @NotNull DateUnit dateUnit2) {
        Comparable comparable;
        Intrinsics.checkNotNullParameter($this$roundToDateUnit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dateUnit2, (String)"dateUnit");
        T t = $this$roundToDateUnit;
        if (t instanceof LocalDate) {
            LocalDate localDate = DateUnitKt.roundToDateUnit((LocalDate)$this$roundToDateUnit, dateUnit2);
            Intrinsics.checkNotNull((Object)localDate, (String)"null cannot be cast to non-null type T of maryk.core.properties.types.DateUnitKt.roundToDateUnit");
            comparable = (Comparable)localDate;
        } else if (t instanceof LocalTime) {
            LocalTime localTime = DateUnitKt.roundToDateUnit((LocalTime)$this$roundToDateUnit, dateUnit2);
            Intrinsics.checkNotNull((Object)localTime, (String)"null cannot be cast to non-null type T of maryk.core.properties.types.DateUnitKt.roundToDateUnit");
            comparable = (Comparable)localTime;
        } else if (t instanceof LocalDateTime) {
            LocalDateTime localDateTime = DateUnitKt.roundToDateUnit((LocalDateTime)$this$roundToDateUnit, dateUnit2);
            Intrinsics.checkNotNull((Object)localDateTime, (String)"null cannot be cast to non-null type T of maryk.core.properties.types.DateUnitKt.roundToDateUnit");
            comparable = (Comparable)localDateTime;
        } else {
            throw new TypeException("Unknown type for IsTemporal");
        }
        return (T)comparable;
    }

    @NotNull
    public static final LocalTime roundToDateUnit(@NotNull LocalTime $this$roundToDateUnit, @NotNull DateUnit dateUnit2) {
        Intrinsics.checkNotNullParameter((Object)$this$roundToDateUnit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dateUnit2, (String)"dateUnit");
        return switch (WhenMappings.$EnumSwitchMapping$0[dateUnit2.ordinal()]) {
            case 1 -> $this$roundToDateUnit;
            case 2 -> new LocalTime($this$roundToDateUnit.getHour(), $this$roundToDateUnit.getMinute(), $this$roundToDateUnit.getSecond(), $this$roundToDateUnit.getNanosecond() / 1000 * 1000);
            case 3 -> new LocalTime($this$roundToDateUnit.getHour(), $this$roundToDateUnit.getMinute(), $this$roundToDateUnit.getSecond(), $this$roundToDateUnit.getNanosecond() / 1000000 * 1000000);
            case 4 -> new LocalTime($this$roundToDateUnit.getHour(), $this$roundToDateUnit.getMinute(), $this$roundToDateUnit.getSecond(), 0, 8, null);
            case 5 -> new LocalTime($this$roundToDateUnit.getHour(), $this$roundToDateUnit.getMinute(), 0, 0, 12, null);
            case 6 -> new LocalTime($this$roundToDateUnit.getHour(), 0, 0, 0, 12, null);
            default -> TimeDefinition.Companion.getMIN();
        };
    }

    @NotNull
    public static final LocalDate roundToDateUnit(@NotNull LocalDate $this$roundToDateUnit, @NotNull DateUnit dateUnit2) {
        Intrinsics.checkNotNullParameter((Object)$this$roundToDateUnit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dateUnit2, (String)"dateUnit");
        return switch (WhenMappings.$EnumSwitchMapping$0[dateUnit2.ordinal()]) {
            case 7 -> new LocalDate($this$roundToDateUnit.getYear(), $this$roundToDateUnit.getMonth(), 1);
            case 8 -> {
                int v1 = switch (WhenMappings.$EnumSwitchMapping$1[$this$roundToDateUnit.getMonth().ordinal()]) {
                    case 1, 2, 3 -> 1;
                    case 4, 5, 6 -> 4;
                    case 7, 8, 9 -> 7;
                    case 10, 11, 12 -> 10;
                    default -> throw new ParseException("Unknown month", null, 2, null);
                };
                int newMonth = v1;
                yield new LocalDate($this$roundToDateUnit.getYear(), newMonth, 1);
            }
            case 9 -> new LocalDate($this$roundToDateUnit.getYear(), 1, 1);
            case 10 -> new LocalDate($this$roundToDateUnit.getYear() - $this$roundToDateUnit.getYear() % 10, 1, 1);
            case 11 -> new LocalDate($this$roundToDateUnit.getYear() - $this$roundToDateUnit.getYear() % 100, 1, 1);
            case 12 -> new LocalDate($this$roundToDateUnit.getYear() - $this$roundToDateUnit.getYear() % 1000, 1, 1);
            default -> $this$roundToDateUnit;
        };
    }

    @NotNull
    public static final LocalDateTime roundToDateUnit(@NotNull LocalDateTime $this$roundToDateUnit, @NotNull DateUnit dateUnit2) {
        LocalDateTime localDateTime;
        Intrinsics.checkNotNullParameter((Object)$this$roundToDateUnit, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dateUnit2, (String)"dateUnit");
        LocalDate it = DateUnitKt.roundToDateUnit($this$roundToDateUnit.getDate(), dateUnit2);
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[dateUnit2.ordinal()]) {
            case 1: {
                localDateTime = LocalDateKt.atTime((LocalDate)it, (int)$this$roundToDateUnit.getHour(), (int)$this$roundToDateUnit.getMinute(), (int)$this$roundToDateUnit.getSecond(), (int)$this$roundToDateUnit.getNanosecond());
                break;
            }
            case 2: {
                localDateTime = LocalDateKt.atTime((LocalDate)it, (int)$this$roundToDateUnit.getHour(), (int)$this$roundToDateUnit.getMinute(), (int)$this$roundToDateUnit.getSecond(), (int)($this$roundToDateUnit.getNanosecond() / 1000 * 1000));
                break;
            }
            case 3: {
                localDateTime = LocalDateKt.atTime((LocalDate)it, (int)$this$roundToDateUnit.getHour(), (int)$this$roundToDateUnit.getMinute(), (int)$this$roundToDateUnit.getSecond(), (int)($this$roundToDateUnit.getNanosecond() / 1000000 * 1000000));
                break;
            }
            case 4: {
                localDateTime = LocalDateKt.atTime$default((LocalDate)it, (int)$this$roundToDateUnit.getHour(), (int)$this$roundToDateUnit.getMinute(), (int)$this$roundToDateUnit.getSecond(), (int)0, (int)8, null);
                break;
            }
            case 5: {
                localDateTime = LocalDateKt.atTime$default((LocalDate)it, (int)$this$roundToDateUnit.getHour(), (int)$this$roundToDateUnit.getMinute(), (int)0, (int)0, (int)12, null);
                break;
            }
            case 6: {
                localDateTime = LocalDateKt.atTime$default((LocalDate)it, (int)$this$roundToDateUnit.getHour(), (int)0, (int)0, (int)0, (int)12, null);
                break;
            }
            default: {
                localDateTime = LocalDateKt.atTime$default((LocalDate)it, (int)0, (int)0, (int)0, (int)0, (int)12, null);
            }
        }
        return localDateTime;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DateUnit.values().length];
            try {
                nArray[DateUnit.Nanos.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateUnit.Micros.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateUnit.Millis.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateUnit.Seconds.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateUnit.Minutes.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateUnit.Hours.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateUnit.Months.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateUnit.Quarters.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateUnit.Years.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateUnit.Decades.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateUnit.Centuries.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DateUnit.Millennia.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Month.values().length];
            try {
                nArray[Month.JANUARY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Month.FEBRUARY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Month.MARCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Month.APRIL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Month.MAY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Month.JUNE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Month.JULY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Month.AUGUST.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Month.SEPTEMBER.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Month.OCTOBER.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Month.NOVEMBER.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Month.DECEMBER.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

