/*
 * Decompiled with CFR 0.152.
 */
package maryk.core.processors.datastore.scanRange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import maryk.core.processors.datastore.scanRange.ScanRange;
import maryk.lib.extensions.compare.ByteArrayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001aR\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00042\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u00a8\u0006\f"}, d2={"createRanges", "", "Lmaryk/core/processors/datastore/scanRange/ScanRange;", "start", "", "", "end", "startInclusive", "", "endInclusive", "startKey", "", "core"})
public final class CreateRangesKt {
    @NotNull
    public static final List<ScanRange> createRanges(@NotNull List<List<Byte>> start, @NotNull List<List<Byte>> end, boolean startInclusive, boolean endInclusive, @Nullable byte[] startKey2) {
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end, (String)"end");
        ArrayList ranges = new ArrayList(Math.max(start.size(), end.size()));
        if (start.size() >= end.size()) {
            int startMultiplier = start.size() / end.size();
            Iterator<List<Byte>> iterator2 = start.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int index2 = n++;
                List<Byte> startList = iterator2.next();
                byte[] startArray = CollectionsKt.toByteArray((Collection)startList);
                ((Collection)ranges).add(new ScanRange(startKey2 != null && ByteArrayKt.compareTo((byte[])startArray, (byte[])startKey2) < 0 ? startKey2 : startArray, startInclusive, CollectionsKt.toByteArray((Collection)end.get((int)Math.floor((double)index2 / (double)startMultiplier))), endInclusive));
            }
        } else {
            int endMultiplier = end.size() / start.size();
            Iterator<List<Byte>> iterator3 = end.iterator();
            int n = 0;
            while (iterator3.hasNext()) {
                int index3 = n++;
                List<Byte> endList = iterator3.next();
                byte[] startArray = CollectionsKt.toByteArray((Collection)start.get((int)Math.floor((double)index3 / (double)endMultiplier)));
                ((Collection)ranges).add(new ScanRange(startKey2 != null && ByteArrayKt.compareTo((byte[])startArray, (byte[])startKey2) < 0 ? startKey2 : startArray, startInclusive, CollectionsKt.toByteArray((Collection)endList), endInclusive));
            }
        }
        return ranges;
    }

    public static /* synthetic */ List createRanges$default(List list2, List list3, boolean bl, boolean bl2, byte[] byArray, int n, Object object) {
        if ((n & 0x10) != 0) {
            byArray = null;
        }
        return CreateRangesKt.createRanges(list2, list3, bl, bl2, byArray);
    }
}

