/*
 * Decompiled with CFR 0.152.
 */
package maryk.core.extensions.bytes;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import maryk.lib.exceptions.ParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\u0003\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0016\u0010\t\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\u0016\u0010\n\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a\f\u0010\u000b\u001a\u00020\b*\u00020\u0001H\u0000\u001a\f\u0010\f\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a9\u0010\u000e\u001a\u00020\u000f*\u00020\u00012!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u000f0\u00112\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0000\u001a/\u0010\u0015\u001a\u00020\u000f*\u00020\u00012!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u000f0\u0011H\u0000\u001a/\u0010\u0016\u001a\u00020\u000f*\u00020\u00012!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u000f0\u0011H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"MAX_SEVEN_VALUE", "", "MIN_SEVEN_VALUE", "initLong", "reader", "Lkotlin/Function0;", "", "length", "", "initLongByVar", "initLongLittleEndian", "calculateVarByteLength", "decodeZigZag", "encodeZigZag", "writeBytes", "", "writer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "byte", "writeLittleEndianBytes", "writeVarBytes", "core"})
public final class LongKt {
    public static final long MAX_SEVEN_VALUE = 0x7FFFFFFFFFFFFFL;
    public static final long MIN_SEVEN_VALUE = -36028797018963968L;

    public static final void writeBytes(long $this$writeBytes, @NotNull Function1<? super Byte, Unit> writer2, int length) {
        Intrinsics.checkNotNullParameter(writer2, (String)"writer");
        if (!(5 <= length ? length < 9 : false)) {
            throw new IllegalArgumentException("Length should be within range of 5 to 8");
        }
        for (int it = 0; it < length; ++it) {
            byte b = (byte)($this$writeBytes >> (length - 1 - it) * 8 & 0xFFL);
            writer2.invoke((Object)(it == 0 ? (byte)(b ^ 0xFFFFFF80) : b));
        }
    }

    public static /* synthetic */ void writeBytes$default(long l, Function1 function1, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8;
        }
        LongKt.writeBytes(l, (Function1<? super Byte, Unit>)function1, n);
    }

    public static final long initLong(@NotNull Function0<Byte> reader2, int length) {
        Intrinsics.checkNotNullParameter(reader2, (String)"reader");
        long l = 0L;
        byte firstByte = ((Number)reader2.invoke()).byteValue();
        if (length < 8) {
            if ((byte)(firstByte & 0xFFFFFF80) != -128) {
                l ^= 0xFFL;
            }
            l <<= 8 * (8 - length);
        }
        l ^= (long)((byte)(firstByte ^ 0xFFFFFF80)) & 0xFFL;
        for (int it = 1; it < length; ++it) {
            l <<= 8;
            l ^= (long)((Number)reader2.invoke()).byteValue() & 0xFFL;
        }
        return l;
    }

    public static /* synthetic */ long initLong$default(Function0 function0, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8;
        }
        return LongKt.initLong((Function0<Byte>)function0, n);
    }

    public static final void writeVarBytes(long $this$writeVarBytes, @NotNull Function1<? super Byte, Unit> writer2) {
        Intrinsics.checkNotNullParameter(writer2, (String)"writer");
        long value2 = $this$writeVarBytes;
        while (true) {
            if ((value2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                writer2.invoke((Object)((byte)value2));
                return;
            }
            writer2.invoke((Object)((byte)(value2 & 0x7FL | 0x80L)));
            value2 >>>= 7;
        }
    }

    public static final long encodeZigZag(long $this$encodeZigZag) {
        return $this$encodeZigZag << 1 ^ $this$encodeZigZag >> 63;
    }

    public static final long decodeZigZag(long $this$decodeZigZag) {
        return $this$decodeZigZag >>> 1 ^ -($this$decodeZigZag & 1L);
    }

    public static final long initLongByVar(@NotNull Function0<Byte> reader2) {
        Intrinsics.checkNotNullParameter(reader2, (String)"reader");
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            long b = ((Number)reader2.invoke()).byteValue();
            result |= (b & 0x7FL) << shift;
            if ((b & 0x80L) != 0L) continue;
            return result;
        }
        throw new ParseException("Malformed varInt", null, 2, null);
    }

    public static final int calculateVarByteLength(long $this$calculateVarByteLength) {
        return ($this$calculateVarByteLength & 0xFFFFFFFFFFFFFF80L) == 0L ? 1 : (($this$calculateVarByteLength & 0xFFFFFFFFFFFFC000L) == 0L ? 2 : (($this$calculateVarByteLength & 0xFFFFFFFFFFE00000L) == 0L ? 3 : (($this$calculateVarByteLength & 0xFFFFFFFFF0000000L) == 0L ? 4 : (($this$calculateVarByteLength & 0xFFFFFFF800000000L) == 0L ? 5 : (($this$calculateVarByteLength & 0xFFFFFC0000000000L) == 0L ? 6 : (($this$calculateVarByteLength & 0xFFFE000000000000L) == 0L ? 7 : (($this$calculateVarByteLength & 0xFF00000000000000L) == 0L ? 8 : (($this$calculateVarByteLength & Long.MIN_VALUE) == 0L ? 9 : 10))))))));
    }

    public static final void writeLittleEndianBytes(long $this$writeLittleEndianBytes, @NotNull Function1<? super Byte, Unit> writer2) {
        Intrinsics.checkNotNullParameter(writer2, (String)"writer");
        for (int it = 0; it < 8; ++it) {
            writer2.invoke((Object)((byte)($this$writeLittleEndianBytes >> it * 8 & 0xFFL)));
        }
    }

    public static final long initLongLittleEndian(@NotNull Function0<Byte> reader2) {
        Intrinsics.checkNotNullParameter(reader2, (String)"reader");
        return (long)((Number)reader2.invoke()).byteValue() & 0xFFL | ((long)((Number)reader2.invoke()).byteValue() & 0xFFL) << 8 | ((long)((Number)reader2.invoke()).byteValue() & 0xFFL) << 16 | ((long)((Number)reader2.invoke()).byteValue() & 0xFFL) << 24 | ((long)((Number)reader2.invoke()).byteValue() & 0xFFL) << 32 | ((long)((Number)reader2.invoke()).byteValue() & 0xFFL) << 40 | ((long)((Number)reader2.invoke()).byteValue() & 0xFFL) << 48 | ((long)((Number)reader2.invoke()).byteValue() & 0xFFL) << 56;
    }
}

