/*
 * Decompiled with CFR 0.152.
 */
package maryk.core.extensions.bytes;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import maryk.lib.exceptions.ParseException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a \u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a;\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\b0\nH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0016\u0010\f\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\u000f\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0001\u001a9\u0010\u0013\u001a\u00020\u0014*\u00020\u00012!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00140\u00162\b\b\u0002\u0010\u0005\u001a\u00020\u0001H\u0000\u001a/\u0010\u001a\u001a\u00020\u0014*\u00020\u00012!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00140\u0016H\u0000\u001a-\u0010\u001b\u001a\u00020\u0014*\u00020\u00012!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00140\u0016\u001a7\u0010\u001c\u001a\u00020\u0014*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00042!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00140\u0016H\u0000\u00a8\u0006\u001e"}, d2={"initInt", "", "reader", "Lkotlin/Function0;", "", "length", "initIntByVar", "initIntByVarWithExtraInfo", "T", "objectCreator", "Lkotlin/Function2;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "initIntLittleEndian", "calculateVarByteLength", "calculateVarIntWithExtraInfoByteSize", "decodeZigZag", "encodeZigZag", "toVarBytes", "", "writeBytes", "", "writer", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "byte", "writeLittleEndianBytes", "writeVarBytes", "writeVarIntWithExtraInfo", "extraInfo", "core"})
public final class IntKt {
    public static final void writeBytes(int $this$writeBytes, @NotNull Function1<? super Byte, Unit> writer2, int length) {
        Intrinsics.checkNotNullParameter(writer2, (String)"writer");
        if (!(3 <= length ? length < 5 : false)) {
            throw new IllegalArgumentException("Length should be within range of 3 to 4");
        }
        for (int it = 0; it < length; ++it) {
            byte b = (byte)($this$writeBytes >> (length - 1 - it) * 8 & 0xFF);
            writer2.invoke((Object)(it == 0 ? (byte)(b ^ 0xFFFFFF80) : b));
        }
    }

    public static /* synthetic */ void writeBytes$default(int n, Function1 function1, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 4;
        }
        IntKt.writeBytes(n, (Function1<? super Byte, Unit>)function1, n2);
    }

    public static final int initInt(@NotNull Function0<Byte> reader2, int length) {
        Intrinsics.checkNotNullParameter(reader2, (String)"reader");
        int n = 0;
        byte firstByte = ((Number)reader2.invoke()).byteValue();
        if (length < 4) {
            if ((byte)(firstByte & 0xFFFFFF80) != -128) {
                n ^= 0xFF;
            }
            n <<= 8 * (8 - length);
        }
        n ^= (byte)(firstByte ^ 0xFFFFFF80) & 0xFF;
        for (int it = 1; it < length; ++it) {
            n <<= 8;
            n ^= ((Number)reader2.invoke()).byteValue() & 0xFF;
        }
        return n;
    }

    public static /* synthetic */ int initInt$default(Function0 function0, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 4;
        }
        return IntKt.initInt((Function0<Byte>)function0, n);
    }

    public static final int encodeZigZag(int $this$encodeZigZag) {
        return $this$encodeZigZag << 1 ^ $this$encodeZigZag >> 31;
    }

    public static final int decodeZigZag(int $this$decodeZigZag) {
        return $this$decodeZigZag >>> 1 ^ -($this$decodeZigZag & 1);
    }

    public static final void writeVarBytes(int $this$writeVarBytes, @NotNull Function1<? super Byte, Unit> writer2) {
        Intrinsics.checkNotNullParameter(writer2, (String)"writer");
        int value2 = $this$writeVarBytes;
        while (true) {
            if ((value2 & 0xFFFFFF80) == 0) {
                writer2.invoke((Object)((byte)value2));
                return;
            }
            writer2.invoke((Object)((byte)(value2 & 0x7F | 0x80)));
            value2 >>>= 7;
        }
    }

    @NotNull
    public static final byte[] toVarBytes(int $this$toVarBytes) {
        byte[] byArray;
        byte[] bytes = byArray = new byte[IntKt.calculateVarByteLength($this$toVarBytes)];
        boolean bl = false;
        Ref.IntRef index2 = new Ref.IntRef();
        IntKt.writeVarBytes($this$toVarBytes, (Function1<? super Byte, Unit>)((Function1)new Function1<Byte, Unit>(bytes, index2){
            final /* synthetic */ byte[] $bytes;
            final /* synthetic */ Ref.IntRef $index;
            {
                this.$bytes = $bytes;
                this.$index = $index;
                super(1);
            }

            public final void invoke(byte it) {
                int n = this.$index.element;
                this.$index.element = n + 1;
                this.$bytes[n] = it;
            }
        }));
        return byArray;
    }

    public static final int initIntByVar(@NotNull Function0<Byte> reader2) {
        Intrinsics.checkNotNullParameter(reader2, (String)"reader");
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            byte b = ((Number)reader2.invoke()).byteValue();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new ParseException("Malformed varInt", null, 2, null);
    }

    public static final int calculateVarByteLength(int $this$calculateVarByteLength) {
        return ($this$calculateVarByteLength & 0xFFFFFF80) == 0 ? 1 : (($this$calculateVarByteLength & 0xFFFFC000) == 0 ? 2 : (($this$calculateVarByteLength & 0xFFE00000) == 0 ? 3 : (($this$calculateVarByteLength & 0xF0000000) == 0 ? 4 : 5)));
    }

    public static final void writeLittleEndianBytes(int $this$writeLittleEndianBytes, @NotNull Function1<? super Byte, Unit> writer2) {
        Intrinsics.checkNotNullParameter(writer2, (String)"writer");
        for (int it = 0; it < 4; ++it) {
            writer2.invoke((Object)((byte)($this$writeLittleEndianBytes >> it * 8 & 0xFF)));
        }
    }

    public static final int initIntLittleEndian(@NotNull Function0<Byte> reader2) {
        Intrinsics.checkNotNullParameter(reader2, (String)"reader");
        return ((Number)reader2.invoke()).byteValue() & 0xFF | (((Number)reader2.invoke()).byteValue() & 0xFF) << 8 | (((Number)reader2.invoke()).byteValue() & 0xFF) << 16 | (((Number)reader2.invoke()).byteValue() & 0xFF) << 24;
    }

    public static final void writeVarIntWithExtraInfo(int $this$writeVarIntWithExtraInfo, byte extraInfo, @NotNull Function1<? super Byte, Unit> writer2) {
        Intrinsics.checkNotNullParameter(writer2, (String)"writer");
        int byteSize2 = IntKt.calculateVarIntWithExtraInfoByteSize($this$writeVarIntWithExtraInfo);
        writer2.invoke((Object)((byte)((byte)((byte)((byte)($this$writeVarIntWithExtraInfo << 3) & 0x78) ^ (byte)(extraInfo & 7)) ^ (byteSize2 > 1 ? -128 : 0))));
        if (byteSize2 > 1) {
            for (int it = 1; it < byteSize2; ++it) {
                boolean isLast = it == byteSize2 - 1;
                writer2.invoke((Object)((byte)((byte)((byte)($this$writeVarIntWithExtraInfo >> 7 * it - 3) & 0x7F) ^ (isLast ? 0 : -128))));
            }
        }
    }

    public static final <T> T initIntByVarWithExtraInfo(@NotNull Function0<Byte> reader2, @NotNull Function2<? super Integer, ? super Byte, ? extends T> objectCreator) {
        Intrinsics.checkNotNullParameter(reader2, (String)"reader");
        Intrinsics.checkNotNullParameter(objectCreator, (String)"objectCreator");
        byte by = ((Number)reader2.invoke()).byteValue();
        byte wireTypeByte = (byte)(by & 7);
        int result = (byte)(by & 0x78) >> 3;
        if ((byte)(by & 0xFFFFFF80) == 0) {
            return (T)objectCreator.invoke((Object)result, (Object)wireTypeByte);
        }
        for (int shift = 4; shift < 35; shift += 7) {
            by = ((Number)reader2.invoke()).byteValue();
            result |= (byte)(by & 0x7F) << shift;
            if ((byte)(by & 0xFFFFFF80) != 0) continue;
            return (T)objectCreator.invoke((Object)result, (Object)wireTypeByte);
        }
        throw new ParseException("Too big tag", null, 2, null);
    }

    public static final int calculateVarIntWithExtraInfoByteSize(int $this$calculateVarIntWithExtraInfoByteSize) {
        return ($this$calculateVarIntWithExtraInfoByteSize & 0xFFFFFFF0) == 0 ? 1 : (($this$calculateVarIntWithExtraInfoByteSize & 0xFFFFF800) == 0 ? 2 : (($this$calculateVarIntWithExtraInfoByteSize & 0xFFFC0000) == 0 ? 3 : (($this$calculateVarIntWithExtraInfoByteSize & 0xFE000000) == 0 ? 4 : 5)));
    }
}

