/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.observers;

import io.mantisrx.mql.shaded.rx.Observer;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.exceptions.OnErrorNotImplementedException;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.functions.Action1;
import io.mantisrx.mql.shaded.rx.observers.Observers;

public final class Subscribers {
    private Subscribers() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> Subscriber<T> empty() {
        return Subscribers.from(Observers.empty());
    }

    public static <T> Subscriber<T> from(final Observer<? super T> o) {
        return new Subscriber<T>(){

            @Override
            public void onCompleted() {
                o.onCompleted();
            }

            @Override
            public void onError(Throwable e2) {
                o.onError(e2);
            }

            @Override
            public void onNext(T t) {
                o.onNext(t);
            }
        };
    }

    public static <T> Subscriber<T> create(final Action1<? super T> onNext) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        return new Subscriber<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e2) {
                throw new OnErrorNotImplementedException(e2);
            }

            @Override
            public final void onNext(T args) {
                onNext.call(args);
            }
        };
    }

    public static <T> Subscriber<T> create(final Action1<? super T> onNext, final Action1<Throwable> onError) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        return new Subscriber<T>(){

            @Override
            public final void onCompleted() {
            }

            @Override
            public final void onError(Throwable e2) {
                onError.call(e2);
            }

            @Override
            public final void onNext(T args) {
                onNext.call(args);
            }
        };
    }

    public static <T> Subscriber<T> create(final Action1<? super T> onNext, final Action1<Throwable> onError, final Action0 onComplete) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        if (onComplete == null) {
            throw new IllegalArgumentException("onComplete can not be null");
        }
        return new Subscriber<T>(){

            @Override
            public final void onCompleted() {
                onComplete.call();
            }

            @Override
            public final void onError(Throwable e2) {
                onError.call(e2);
            }

            @Override
            public final void onNext(T args) {
                onNext.call(args);
            }
        };
    }

    public static <T> Subscriber<T> wrap(final Subscriber<? super T> subscriber2) {
        return new Subscriber<T>(subscriber2){

            @Override
            public void onCompleted() {
                subscriber2.onCompleted();
            }

            @Override
            public void onError(Throwable e2) {
                subscriber2.onError(e2);
            }

            @Override
            public void onNext(T t) {
                subscriber2.onNext(t);
            }
        };
    }
}

