/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.observables;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Observer;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.exceptions.OnErrorNotImplementedException;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.functions.Action1;
import io.mantisrx.mql.shaded.rx.functions.Actions;
import io.mantisrx.mql.shaded.rx.functions.Func1;
import io.mantisrx.mql.shaded.rx.internal.operators.BlockingOperatorLatest;
import io.mantisrx.mql.shaded.rx.internal.operators.BlockingOperatorMostRecent;
import io.mantisrx.mql.shaded.rx.internal.operators.BlockingOperatorNext;
import io.mantisrx.mql.shaded.rx.internal.operators.BlockingOperatorToFuture;
import io.mantisrx.mql.shaded.rx.internal.operators.BlockingOperatorToIterator;
import io.mantisrx.mql.shaded.rx.internal.operators.NotificationLite;
import io.mantisrx.mql.shaded.rx.internal.util.BlockingUtils;
import io.mantisrx.mql.shaded.rx.internal.util.UtilityFunctions;
import io.mantisrx.mql.shaded.rx.subscriptions.Subscriptions;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;

public final class BlockingObservable<T> {
    private final Observable<? extends T> o;
    static final Object ON_START = new Object();
    static final Object SET_PRODUCER = new Object();
    static final Object UNSUBSCRIBE = new Object();

    private BlockingObservable(Observable<? extends T> o) {
        this.o = o;
    }

    public static <T> BlockingObservable<T> from(Observable<? extends T> o) {
        return new BlockingObservable<T>(o);
    }

    public void forEach(final Action1<? super T> onNext) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference exceptionFromOnError = new AtomicReference();
        Subscription subscription2 = this.o.subscribe(new Subscriber<T>(){

            @Override
            public void onCompleted() {
                latch.countDown();
            }

            @Override
            public void onError(Throwable e2) {
                exceptionFromOnError.set(e2);
                latch.countDown();
            }

            @Override
            public void onNext(T args) {
                onNext.call(args);
            }
        });
        BlockingUtils.awaitForComplete(latch, subscription2);
        if (exceptionFromOnError.get() != null) {
            Exceptions.propagate((Throwable)exceptionFromOnError.get());
        }
    }

    public Iterator<T> getIterator() {
        return BlockingOperatorToIterator.toIterator(this.o);
    }

    public T first() {
        return this.blockForSingle(this.o.first());
    }

    public T first(Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.first(predicate));
    }

    public T firstOrDefault(T defaultValue) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).firstOrDefault(defaultValue));
    }

    public T firstOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.filter(predicate).map(UtilityFunctions.identity()).firstOrDefault(defaultValue));
    }

    public T last() {
        return this.blockForSingle(this.o.last());
    }

    public T last(Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.last(predicate));
    }

    public T lastOrDefault(T defaultValue) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).lastOrDefault(defaultValue));
    }

    public T lastOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.filter(predicate).map(UtilityFunctions.identity()).lastOrDefault(defaultValue));
    }

    public Iterable<T> mostRecent(T initialValue) {
        return BlockingOperatorMostRecent.mostRecent(this.o, initialValue);
    }

    public Iterable<T> next() {
        return BlockingOperatorNext.next(this.o);
    }

    public Iterable<T> latest() {
        return BlockingOperatorLatest.latest(this.o);
    }

    public T single() {
        return this.blockForSingle(this.o.single());
    }

    public T single(Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.single(predicate));
    }

    public T singleOrDefault(T defaultValue) {
        return this.blockForSingle(this.o.map(UtilityFunctions.identity()).singleOrDefault(defaultValue));
    }

    public T singleOrDefault(T defaultValue, Func1<? super T, Boolean> predicate) {
        return this.blockForSingle(this.o.filter(predicate).map(UtilityFunctions.identity()).singleOrDefault(defaultValue));
    }

    public Future<T> toFuture() {
        return BlockingOperatorToFuture.toFuture(this.o);
    }

    public Iterable<T> toIterable() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return BlockingObservable.this.getIterator();
            }
        };
    }

    private T blockForSingle(Observable<? extends T> observable) {
        final AtomicReference returnItem = new AtomicReference();
        final AtomicReference returnException = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Subscription subscription2 = observable.subscribe(new Subscriber<T>(){

            @Override
            public void onCompleted() {
                latch.countDown();
            }

            @Override
            public void onError(Throwable e2) {
                returnException.set(e2);
                latch.countDown();
            }

            @Override
            public void onNext(T item) {
                returnItem.set(item);
            }
        });
        BlockingUtils.awaitForComplete(latch, subscription2);
        if (returnException.get() != null) {
            Exceptions.propagate((Throwable)returnException.get());
        }
        return (T)returnItem.get();
    }

    public void subscribe() {
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] error = new Throwable[]{null};
        Subscription s = this.o.subscribe(new Subscriber<T>(){

            @Override
            public void onNext(T t) {
            }

            @Override
            public void onError(Throwable e2) {
                error[0] = e2;
                cdl.countDown();
            }

            @Override
            public void onCompleted() {
                cdl.countDown();
            }
        });
        BlockingUtils.awaitForComplete(cdl, s);
        Throwable e2 = error[0];
        if (e2 != null) {
            Exceptions.propagate(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void subscribe(Observer<? super T> observer) {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Subscription s = this.o.subscribe(new Subscriber<T>(){

            @Override
            public void onNext(T t) {
                queue.offer(NotificationLite.next(t));
            }

            @Override
            public void onError(Throwable e2) {
                queue.offer(NotificationLite.error(e2));
            }

            @Override
            public void onCompleted() {
                queue.offer(NotificationLite.completed());
            }
        });
        try {
            while (true) {
                Object o;
                if ((o = queue.poll()) == null) {
                    o = queue.take();
                }
                if (NotificationLite.accept(observer, o)) {
                    return;
                }
                continue;
                break;
            }
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            observer.onError(e2);
            return;
        }
        finally {
            s.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(Subscriber<? super T> subscriber2) {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        final Producer[] theProducer = new Producer[]{null};
        Subscriber s = new Subscriber<T>(){

            @Override
            public void onNext(T t) {
                queue.offer(NotificationLite.next(t));
            }

            @Override
            public void onError(Throwable e2) {
                queue.offer(NotificationLite.error(e2));
            }

            @Override
            public void onCompleted() {
                queue.offer(NotificationLite.completed());
            }

            @Override
            public void setProducer(Producer p) {
                theProducer[0] = p;
                queue.offer(SET_PRODUCER);
            }

            @Override
            public void onStart() {
                queue.offer(ON_START);
            }
        };
        subscriber2.add(s);
        subscriber2.add(Subscriptions.create(new Action0(){

            @Override
            public void call() {
                queue.offer(UNSUBSCRIBE);
            }
        }));
        this.o.subscribe(s);
        try {
            while (!subscriber2.isUnsubscribed()) {
                Object o = queue.poll();
                if (o == null) {
                    o = queue.take();
                }
                if (subscriber2.isUnsubscribed()) break;
                if (o == UNSUBSCRIBE) {
                    break;
                }
                if (o == ON_START) {
                    subscriber2.onStart();
                    continue;
                }
                if (o == SET_PRODUCER) {
                    subscriber2.setProducer(theProducer[0]);
                    continue;
                }
                if (!NotificationLite.accept(subscriber2, o)) continue;
                return;
            }
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            subscriber2.onError(e2);
        }
        finally {
            s.unsubscribe();
        }
    }

    public void subscribe(Action1<? super T> onNext) {
        this.subscribe(onNext, (Action1<Throwable>)new Action1<Throwable>(){

            @Override
            public void call(Throwable t) {
                throw new OnErrorNotImplementedException(t);
            }
        }, Actions.empty());
    }

    public void subscribe(Action1<? super T> onNext, Action1<? super Throwable> onError) {
        this.subscribe(onNext, onError, Actions.empty());
    }

    public void subscribe(final Action1<? super T> onNext, final Action1<? super Throwable> onError, final Action0 onCompleted) {
        this.subscribe(new Observer<T>(){

            @Override
            public void onNext(T t) {
                onNext.call(t);
            }

            @Override
            public void onError(Throwable e2) {
                onError.call(e2);
            }

            @Override
            public void onCompleted() {
                onCompleted.call();
            }
        });
    }
}

