/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.util.unsafe;

import io.mantisrx.mql.shaded.rx.internal.util.SuppressAnimalSniffer;
import io.mantisrx.mql.shaded.rx.internal.util.unsafe.ConcurrentCircularArrayQueue;
import io.mantisrx.mql.shaded.rx.internal.util.unsafe.UnsafeAccess;

@SuppressAnimalSniffer
public abstract class ConcurrentSequencedCircularArrayQueue<E>
extends ConcurrentCircularArrayQueue<E> {
    private static final long ARRAY_BASE;
    private static final int ELEMENT_SHIFT;
    protected final long[] sequenceBuffer;

    public ConcurrentSequencedCircularArrayQueue(int capacity) {
        super(capacity);
        int actualCapacity = (int)(this.mask + 1L);
        this.sequenceBuffer = new long[(actualCapacity << SPARSE_SHIFT) + 64];
        for (long i = 0L; i < (long)actualCapacity; ++i) {
            this.soSequence(this.sequenceBuffer, this.calcSequenceOffset(i), i);
        }
    }

    protected final long calcSequenceOffset(long index2) {
        return ARRAY_BASE + ((index2 & this.mask) << ELEMENT_SHIFT);
    }

    protected final void soSequence(long[] buffer, long offset, long e2) {
        UnsafeAccess.UNSAFE.putOrderedLong(buffer, offset, e2);
    }

    protected final long lvSequence(long[] buffer, long offset) {
        return UnsafeAccess.UNSAFE.getLongVolatile(buffer, offset);
    }

    static {
        int scale = UnsafeAccess.UNSAFE.arrayIndexScale(long[].class);
        if (8 != scale) {
            throw new IllegalStateException("Unexpected long[] element size");
        }
        ELEMENT_SHIFT = 3 + SPARSE_SHIFT;
        ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(long[].class) + (32 << ELEMENT_SHIFT - SPARSE_SHIFT);
    }
}

