/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.util;

import io.mantisrx.mql.shaded.rx.Scheduler;
import io.mantisrx.mql.shaded.rx.Single;
import io.mantisrx.mql.shaded.rx.SingleSubscriber;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.functions.Func1;
import io.mantisrx.mql.shaded.rx.internal.schedulers.EventLoopsScheduler;

public final class ScalarSynchronousSingle<T>
extends Single<T> {
    final T value;

    public static <T> ScalarSynchronousSingle<T> create(T t) {
        return new ScalarSynchronousSingle<T>(t);
    }

    protected ScalarSynchronousSingle(final T t) {
        super(new Single.OnSubscribe<T>(){

            @Override
            public void call(SingleSubscriber<? super T> te) {
                te.onSuccess(t);
            }
        });
        this.value = t;
    }

    public T get() {
        return this.value;
    }

    public Single<T> scalarScheduleOn(Scheduler scheduler) {
        if (scheduler instanceof EventLoopsScheduler) {
            EventLoopsScheduler es = (EventLoopsScheduler)scheduler;
            return ScalarSynchronousSingle.create(new DirectScheduledEmission<T>(es, this.value));
        }
        return ScalarSynchronousSingle.create(new NormalScheduledEmission<T>(scheduler, this.value));
    }

    public <R> Single<R> scalarFlatMap(final Func1<? super T, ? extends Single<? extends R>> func) {
        return ScalarSynchronousSingle.create(new Single.OnSubscribe<R>(){

            @Override
            public void call(final SingleSubscriber<? super R> child) {
                Single o = (Single)func.call(ScalarSynchronousSingle.this.value);
                if (o instanceof ScalarSynchronousSingle) {
                    child.onSuccess(((ScalarSynchronousSingle)o).value);
                } else {
                    SingleSubscriber subscriber2 = new SingleSubscriber<R>(){

                        @Override
                        public void onError(Throwable e2) {
                            child.onError(e2);
                        }

                        @Override
                        public void onSuccess(R r) {
                            child.onSuccess(r);
                        }
                    };
                    child.add(subscriber2);
                    o.subscribe(subscriber2);
                }
            }
        });
    }

    static final class ScalarSynchronousSingleAction<T>
    implements Action0 {
        private final SingleSubscriber<? super T> subscriber;
        private final T value;

        ScalarSynchronousSingleAction(SingleSubscriber<? super T> subscriber2, T value) {
            this.subscriber = subscriber2;
            this.value = value;
        }

        @Override
        public void call() {
            try {
                this.subscriber.onSuccess(this.value);
            }
            catch (Throwable t) {
                this.subscriber.onError(t);
            }
        }
    }

    static final class NormalScheduledEmission<T>
    implements Single.OnSubscribe<T> {
        private final Scheduler scheduler;
        private final T value;

        NormalScheduledEmission(Scheduler scheduler, T value) {
            this.scheduler = scheduler;
            this.value = value;
        }

        @Override
        public void call(SingleSubscriber<? super T> singleSubscriber) {
            Scheduler.Worker worker = this.scheduler.createWorker();
            singleSubscriber.add(worker);
            worker.schedule(new ScalarSynchronousSingleAction<T>(singleSubscriber, this.value));
        }
    }

    static final class DirectScheduledEmission<T>
    implements Single.OnSubscribe<T> {
        private final EventLoopsScheduler es;
        private final T value;

        DirectScheduledEmission(EventLoopsScheduler es, T value) {
            this.es = es;
            this.value = value;
        }

        @Override
        public void call(SingleSubscriber<? super T> singleSubscriber) {
            singleSubscriber.add(this.es.scheduleDirect(new ScalarSynchronousSingleAction<T>(singleSubscriber, this.value)));
        }
    }
}

