/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.schedulers;

import io.mantisrx.mql.shaded.rx.Scheduler;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.internal.schedulers.ScheduledAction;
import io.mantisrx.mql.shaded.rx.internal.util.PlatformDependent;
import io.mantisrx.mql.shaded.rx.internal.util.RxThreadFactory;
import io.mantisrx.mql.shaded.rx.internal.util.SubscriptionList;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import io.mantisrx.mql.shaded.rx.subscriptions.CompositeSubscription;
import io.mantisrx.mql.shaded.rx.subscriptions.Subscriptions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class NewThreadWorker
extends Scheduler.Worker
implements Subscription {
    private final ScheduledExecutorService executor;
    volatile boolean isUnsubscribed;
    private static final String FREQUENCY_KEY = "io.mantisrx.mql.shaded.rx.scheduler.jdk6.purge-frequency-millis";
    private static final String PURGE_FORCE_KEY = "io.mantisrx.mql.shaded.rx.scheduler.jdk6.purge-force";
    private static final String PURGE_THREAD_PREFIX = "RxSchedulerPurge-";
    private static final boolean SHOULD_TRY_ENABLE_CANCEL_POLICY;
    public static final int PURGE_FREQUENCY;
    private static final ConcurrentHashMap<ScheduledThreadPoolExecutor, ScheduledThreadPoolExecutor> EXECUTORS;
    private static final AtomicReference<ScheduledExecutorService> PURGE;
    private static volatile Object cachedSetRemoveOnCancelPolicyMethod;
    private static final Object SET_REMOVE_ON_CANCEL_POLICY_METHOD_NOT_SUPPORTED;

    public static void registerExecutor(ScheduledThreadPoolExecutor service) {
        ScheduledExecutorService exec;
        while ((exec = PURGE.get()) == null) {
            exec = Executors.newScheduledThreadPool(1, new RxThreadFactory(PURGE_THREAD_PREFIX));
            if (PURGE.compareAndSet(null, exec)) {
                exec.scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        NewThreadWorker.purgeExecutors();
                    }
                }, PURGE_FREQUENCY, PURGE_FREQUENCY, TimeUnit.MILLISECONDS);
                break;
            }
            exec.shutdownNow();
        }
        EXECUTORS.putIfAbsent(service, service);
    }

    public static void deregisterExecutor(ScheduledExecutorService service) {
        EXECUTORS.remove(service);
    }

    static void purgeExecutors() {
        try {
            ConcurrentHashMap<ScheduledThreadPoolExecutor, ScheduledThreadPoolExecutor> map2 = EXECUTORS;
            Iterator it = map2.keySet().iterator();
            while (it.hasNext()) {
                ScheduledThreadPoolExecutor exec = (ScheduledThreadPoolExecutor)it.next();
                if (!exec.isShutdown()) {
                    exec.purge();
                    continue;
                }
                it.remove();
            }
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            RxJavaHooks.onError(t);
        }
    }

    public static boolean tryEnableCancelPolicy(ScheduledExecutorService executor) {
        if (SHOULD_TRY_ENABLE_CANCEL_POLICY) {
            Method methodToCall;
            boolean isInstanceOfScheduledThreadPoolExecutor = executor instanceof ScheduledThreadPoolExecutor;
            if (isInstanceOfScheduledThreadPoolExecutor) {
                Object localSetRemoveOnCancelPolicyMethod = cachedSetRemoveOnCancelPolicyMethod;
                if (localSetRemoveOnCancelPolicyMethod == SET_REMOVE_ON_CANCEL_POLICY_METHOD_NOT_SUPPORTED) {
                    return false;
                }
                if (localSetRemoveOnCancelPolicyMethod == null) {
                    Method method = NewThreadWorker.findSetRemoveOnCancelPolicyMethod(executor);
                    cachedSetRemoveOnCancelPolicyMethod = method != null ? method : SET_REMOVE_ON_CANCEL_POLICY_METHOD_NOT_SUPPORTED;
                    methodToCall = method;
                } else {
                    methodToCall = (Method)localSetRemoveOnCancelPolicyMethod;
                }
            } else {
                methodToCall = NewThreadWorker.findSetRemoveOnCancelPolicyMethod(executor);
            }
            if (methodToCall != null) {
                try {
                    methodToCall.invoke((Object)executor, true);
                    return true;
                }
                catch (InvocationTargetException e2) {
                    RxJavaHooks.onError(e2);
                }
                catch (IllegalAccessException e3) {
                    RxJavaHooks.onError(e3);
                }
                catch (IllegalArgumentException e4) {
                    RxJavaHooks.onError(e4);
                }
            }
        }
        return false;
    }

    static Method findSetRemoveOnCancelPolicyMethod(ScheduledExecutorService executor) {
        for (Method method : executor.getClass().getMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals("setRemoveOnCancelPolicy") || (parameterTypes = method.getParameterTypes()).length != 1 || parameterTypes[0] != Boolean.TYPE) continue;
            return method;
        }
        return null;
    }

    public NewThreadWorker(ThreadFactory threadFactory) {
        ScheduledExecutorService exec = Executors.newScheduledThreadPool(1, threadFactory);
        boolean cancelSupported = NewThreadWorker.tryEnableCancelPolicy(exec);
        if (!cancelSupported && exec instanceof ScheduledThreadPoolExecutor) {
            NewThreadWorker.registerExecutor((ScheduledThreadPoolExecutor)exec);
        }
        this.executor = exec;
    }

    @Override
    public Subscription schedule(Action0 action2) {
        return this.schedule(action2, 0L, null);
    }

    @Override
    public Subscription schedule(Action0 action2, long delayTime, TimeUnit unit) {
        if (this.isUnsubscribed) {
            return Subscriptions.unsubscribed();
        }
        return this.scheduleActual(action2, delayTime, unit);
    }

    public ScheduledAction scheduleActual(Action0 action2, long delayTime, TimeUnit unit) {
        Action0 decoratedAction = RxJavaHooks.onScheduledAction(action2);
        ScheduledAction run2 = new ScheduledAction(decoratedAction);
        Future<?> f = delayTime <= 0L ? this.executor.submit(run2) : this.executor.schedule(run2, delayTime, unit);
        run2.add(f);
        return run2;
    }

    public ScheduledAction scheduleActual(Action0 action2, long delayTime, TimeUnit unit, CompositeSubscription parent) {
        Action0 decoratedAction = RxJavaHooks.onScheduledAction(action2);
        ScheduledAction run2 = new ScheduledAction(decoratedAction, parent);
        parent.add(run2);
        Future<?> f = delayTime <= 0L ? this.executor.submit(run2) : this.executor.schedule(run2, delayTime, unit);
        run2.add(f);
        return run2;
    }

    public ScheduledAction scheduleActual(Action0 action2, long delayTime, TimeUnit unit, SubscriptionList parent) {
        Action0 decoratedAction = RxJavaHooks.onScheduledAction(action2);
        ScheduledAction run2 = new ScheduledAction(decoratedAction, parent);
        parent.add(run2);
        Future<?> f = delayTime <= 0L ? this.executor.submit(run2) : this.executor.schedule(run2, delayTime, unit);
        run2.add(f);
        return run2;
    }

    @Override
    public void unsubscribe() {
        this.isUnsubscribed = true;
        this.executor.shutdownNow();
        NewThreadWorker.deregisterExecutor(this.executor);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.isUnsubscribed;
    }

    static {
        SET_REMOVE_ON_CANCEL_POLICY_METHOD_NOT_SUPPORTED = new Object();
        EXECUTORS = new ConcurrentHashMap();
        PURGE = new AtomicReference();
        PURGE_FREQUENCY = Integer.getInteger(FREQUENCY_KEY, 1000);
        boolean purgeForce = Boolean.getBoolean(PURGE_FORCE_KEY);
        int androidApiVersion = PlatformDependent.getAndroidApiVersion();
        SHOULD_TRY_ENABLE_CANCEL_POLICY = !purgeForce && (androidApiVersion == 0 || androidApiVersion >= 21);
    }
}

