/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.schedulers;

import io.mantisrx.mql.shaded.rx.Scheduler;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.internal.schedulers.SleepingAction;
import io.mantisrx.mql.shaded.rx.subscriptions.BooleanSubscription;
import io.mantisrx.mql.shaded.rx.subscriptions.Subscriptions;
import java.util.concurrent.TimeUnit;

public final class ImmediateScheduler
extends Scheduler {
    public static final ImmediateScheduler INSTANCE = new ImmediateScheduler();

    private ImmediateScheduler() {
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new InnerImmediateScheduler();
    }

    final class InnerImmediateScheduler
    extends Scheduler.Worker
    implements Subscription {
        final BooleanSubscription innerSubscription = new BooleanSubscription();

        InnerImmediateScheduler() {
        }

        @Override
        public Subscription schedule(Action0 action2, long delayTime, TimeUnit unit) {
            long execTime = ImmediateScheduler.this.now() + unit.toMillis(delayTime);
            return this.schedule(new SleepingAction(action2, this, execTime));
        }

        @Override
        public Subscription schedule(Action0 action2) {
            action2.call();
            return Subscriptions.unsubscribed();
        }

        @Override
        public void unsubscribe() {
            this.innerSubscription.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.innerSubscription.isUnsubscribed();
        }
    }
}

