/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Single;
import io.mantisrx.mql.shaded.rx.SingleSubscriber;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.FuncN;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import io.mantisrx.mql.shaded.rx.subscriptions.CompositeSubscription;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class SingleOperatorZip {
    private SingleOperatorZip() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, R> Single<R> zip(final Single<? extends T>[] singles, final FuncN<? extends R> zipper2) {
        return Single.create(new Single.OnSubscribe<R>(){

            @Override
            public void call(final SingleSubscriber<? super R> subscriber2) {
                if (singles.length == 0) {
                    subscriber2.onError(new NoSuchElementException("Can't zip 0 Singles."));
                    return;
                }
                final AtomicInteger wip = new AtomicInteger(singles.length);
                final AtomicBoolean once = new AtomicBoolean();
                final Object[] values = new Object[singles.length];
                CompositeSubscription compositeSubscription = new CompositeSubscription();
                subscriber2.add(compositeSubscription);
                for (int i = 0; i < singles.length && !compositeSubscription.isUnsubscribed() && !once.get(); ++i) {
                    final int j = i;
                    SingleSubscriber singleSubscriber = new SingleSubscriber<T>(){

                        @Override
                        public void onSuccess(T value) {
                            values[j] = value;
                            if (wip.decrementAndGet() == 0) {
                                Object r;
                                try {
                                    r = zipper2.call(values);
                                }
                                catch (Throwable e2) {
                                    Exceptions.throwIfFatal(e2);
                                    this.onError(e2);
                                    return;
                                }
                                subscriber2.onSuccess(r);
                            }
                        }

                        @Override
                        public void onError(Throwable error) {
                            if (once.compareAndSet(false, true)) {
                                subscriber2.onError(error);
                            } else {
                                RxJavaHooks.onError(error);
                            }
                        }
                    };
                    compositeSubscription.add(singleSubscriber);
                    if (compositeSubscription.isUnsubscribed() || once.get()) break;
                    singles[i].subscribe(singleSubscriber);
                }
            }
        });
    }
}

