/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Scheduler;
import io.mantisrx.mql.shaded.rx.Single;
import io.mantisrx.mql.shaded.rx.SingleSubscriber;
import io.mantisrx.mql.shaded.rx.functions.Action0;

public final class SingleObserveOn<T>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final Scheduler scheduler;

    public SingleObserveOn(Single.OnSubscribe<T> source2, Scheduler scheduler) {
        this.source = source2;
        this.scheduler = scheduler;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        Scheduler.Worker w = this.scheduler.createWorker();
        ObserveOnSingleSubscriber<? super T> parent = new ObserveOnSingleSubscriber<T>(t, w);
        t.add(w);
        t.add(parent);
        this.source.call(parent);
    }

    static final class ObserveOnSingleSubscriber<T>
    extends SingleSubscriber<T>
    implements Action0 {
        final SingleSubscriber<? super T> actual;
        final Scheduler.Worker w;
        T value;
        Throwable error;

        public ObserveOnSingleSubscriber(SingleSubscriber<? super T> actual, Scheduler.Worker w) {
            this.actual = actual;
            this.w = w;
        }

        @Override
        public void onSuccess(T value) {
            this.value = value;
            this.w.schedule(this);
        }

        @Override
        public void onError(Throwable error) {
            this.error = error;
            this.w.schedule(this);
        }

        @Override
        public void call() {
            try {
                Throwable ex = this.error;
                if (ex != null) {
                    this.error = null;
                    this.actual.onError(ex);
                } else {
                    T v = this.value;
                    this.value = null;
                    this.actual.onSuccess(v);
                }
            }
            finally {
                this.w.unsubscribe();
            }
        }
    }
}

