/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Single;
import io.mantisrx.mql.shaded.rx.SingleEmitter;
import io.mantisrx.mql.shaded.rx.SingleSubscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.Action1;
import io.mantisrx.mql.shaded.rx.functions.Cancellable;
import io.mantisrx.mql.shaded.rx.internal.subscriptions.CancellableSubscription;
import io.mantisrx.mql.shaded.rx.internal.subscriptions.SequentialSubscription;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SingleFromEmitter<T>
implements Single.OnSubscribe<T> {
    final Action1<SingleEmitter<T>> producer;

    public SingleFromEmitter(Action1<SingleEmitter<T>> producer) {
        this.producer = producer;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        SingleEmitterImpl<T> parent = new SingleEmitterImpl<T>(t);
        t.add(parent);
        try {
            this.producer.call(parent);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            parent.onError(ex);
        }
    }

    static final class SingleEmitterImpl<T>
    extends AtomicBoolean
    implements SingleEmitter<T>,
    Subscription {
        private static final long serialVersionUID = 8082834163465882809L;
        final SingleSubscriber<? super T> actual;
        final SequentialSubscription resource;

        SingleEmitterImpl(SingleSubscriber<? super T> actual) {
            this.actual = actual;
            this.resource = new SequentialSubscription();
        }

        @Override
        public void unsubscribe() {
            if (this.compareAndSet(false, true)) {
                this.resource.unsubscribe();
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get();
        }

        @Override
        public void onSuccess(T t) {
            if (this.compareAndSet(false, true)) {
                try {
                    this.actual.onSuccess(t);
                }
                finally {
                    this.resource.unsubscribe();
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (t == null) {
                t = new NullPointerException();
            }
            if (this.compareAndSet(false, true)) {
                try {
                    this.actual.onError(t);
                }
                finally {
                    this.resource.unsubscribe();
                }
            } else {
                RxJavaHooks.onError(t);
            }
        }

        @Override
        public void setSubscription(Subscription s) {
            this.resource.update(s);
        }

        @Override
        public void setCancellation(Cancellable c) {
            this.setSubscription(new CancellableSubscription(c));
        }
    }
}

