/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Single;
import io.mantisrx.mql.shaded.rx.SingleSubscriber;
import io.mantisrx.mql.shaded.rx.exceptions.CompositeException;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.Action1;

public final class SingleDoOnEvent<T>
implements Single.OnSubscribe<T> {
    final Single<T> source;
    final Action1<? super T> onSuccess;
    final Action1<Throwable> onError;

    public SingleDoOnEvent(Single<T> source2, Action1<? super T> onSuccess, Action1<Throwable> onError) {
        this.source = source2;
        this.onSuccess = onSuccess;
        this.onError = onError;
    }

    @Override
    public void call(SingleSubscriber<? super T> actual) {
        SingleDoOnEventSubscriber<? super T> parent = new SingleDoOnEventSubscriber<T>(actual, this.onSuccess, this.onError);
        actual.add(parent);
        this.source.subscribe(parent);
    }

    static final class SingleDoOnEventSubscriber<T>
    extends SingleSubscriber<T> {
        final SingleSubscriber<? super T> actual;
        final Action1<? super T> onSuccess;
        final Action1<Throwable> onError;

        SingleDoOnEventSubscriber(SingleSubscriber<? super T> actual, Action1<? super T> onSuccess, Action1<Throwable> onError) {
            this.actual = actual;
            this.onSuccess = onSuccess;
            this.onError = onError;
        }

        @Override
        public void onSuccess(T value) {
            try {
                this.onSuccess.call(value);
            }
            catch (Throwable e2) {
                Exceptions.throwOrReport(e2, this, value);
                return;
            }
            this.actual.onSuccess(value);
        }

        @Override
        public void onError(Throwable error) {
            try {
                this.onError.call(error);
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                this.actual.onError(new CompositeException(error, e2));
                return;
            }
            this.actual.onError(error);
        }
    }
}

