/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Scheduler;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.schedulers.Timestamped;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;

public class OperatorSkipLastTimed<T>
implements Observable.Operator<T, T> {
    final long timeInMillis;
    final Scheduler scheduler;

    public OperatorSkipLastTimed(long time2, TimeUnit unit, Scheduler scheduler) {
        this.timeInMillis = unit.toMillis(time2);
        this.scheduler = scheduler;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber2) {
        return new Subscriber<T>(subscriber2){
            private Deque<Timestamped<T>> buffer;
            {
                super(subscriber22);
                this.buffer = new ArrayDeque();
            }

            private void emitItemsOutOfWindow(long now) {
                Timestamped v;
                long limit2 = now - OperatorSkipLastTimed.this.timeInMillis;
                while (!this.buffer.isEmpty() && (v = this.buffer.getFirst()).getTimestampMillis() < limit2) {
                    this.buffer.removeFirst();
                    subscriber2.onNext(v.getValue());
                }
            }

            @Override
            public void onNext(T value) {
                long now = OperatorSkipLastTimed.this.scheduler.now();
                this.emitItemsOutOfWindow(now);
                this.buffer.offerLast(new Timestamped(now, value));
            }

            @Override
            public void onError(Throwable e2) {
                subscriber2.onError(e2);
            }

            @Override
            public void onCompleted() {
                this.emitItemsOutOfWindow(OperatorSkipLastTimed.this.scheduler.now());
                subscriber2.onCompleted();
            }
        };
    }
}

