/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Scheduler;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.exceptions.OnErrorThrowable;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.functions.Action1;
import io.mantisrx.mql.shaded.rx.functions.Func0;
import io.mantisrx.mql.shaded.rx.functions.Func1;
import io.mantisrx.mql.shaded.rx.internal.operators.NotificationLite;
import io.mantisrx.mql.shaded.rx.internal.util.OpenHashSet;
import io.mantisrx.mql.shaded.rx.observables.ConnectableObservable;
import io.mantisrx.mql.shaded.rx.schedulers.Timestamped;
import io.mantisrx.mql.shaded.rx.subscriptions.Subscriptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class OperatorReplay<T>
extends ConnectableObservable<T>
implements Subscription {
    final Observable<? extends T> source;
    final AtomicReference<ReplaySubscriber<T>> current;
    final Func0<? extends ReplayBuffer<T>> bufferFactory;
    static final Func0 DEFAULT_UNBOUNDED_FACTORY = new Func0(){

        @Override
        public Object call() {
            return new UnboundedReplayBuffer(16);
        }
    };

    public static <T, U, R> Observable<R> multicastSelector(final Func0<? extends ConnectableObservable<U>> connectableFactory, final Func1<? super Observable<U>, ? extends Observable<R>> selector) {
        return Observable.unsafeCreate(new Observable.OnSubscribe<R>(){

            @Override
            public void call(final Subscriber<? super R> child) {
                Observable observable;
                ConnectableObservable co;
                try {
                    co = (ConnectableObservable)connectableFactory.call();
                    observable = (Observable)selector.call(co);
                }
                catch (Throwable e2) {
                    Exceptions.throwOrReport(e2, child);
                    return;
                }
                observable.subscribe(child);
                co.connect((Action1<Subscription>)new Action1<Subscription>(){

                    @Override
                    public void call(Subscription t) {
                        child.add(t);
                    }
                });
            }
        });
    }

    public static <T> ConnectableObservable<T> observeOn(final ConnectableObservable<T> co, Scheduler scheduler) {
        final Observable observable = co.observeOn(scheduler);
        Observable.OnSubscribe onSubscribe = new Observable.OnSubscribe<T>(){

            @Override
            public void call(final Subscriber<? super T> child) {
                observable.unsafeSubscribe(new Subscriber<T>(child){

                    @Override
                    public void onNext(T t) {
                        child.onNext(t);
                    }

                    @Override
                    public void onError(Throwable e2) {
                        child.onError(e2);
                    }

                    @Override
                    public void onCompleted() {
                        child.onCompleted();
                    }
                });
            }
        };
        return new ConnectableObservable<T>(onSubscribe){

            @Override
            public void connect(Action1<? super Subscription> connection) {
                co.connect(connection);
            }
        };
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source2) {
        return OperatorReplay.create(source2, DEFAULT_UNBOUNDED_FACTORY);
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source2, final int bufferSize) {
        if (bufferSize == Integer.MAX_VALUE) {
            return OperatorReplay.create(source2);
        }
        return OperatorReplay.create(source2, new Func0<ReplayBuffer<T>>(){

            @Override
            public ReplayBuffer<T> call() {
                return new SizeBoundReplayBuffer(bufferSize);
            }
        });
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source2, long maxAge, TimeUnit unit, Scheduler scheduler) {
        return OperatorReplay.create(source2, maxAge, unit, scheduler, Integer.MAX_VALUE);
    }

    public static <T> ConnectableObservable<T> create(Observable<? extends T> source2, long maxAge, TimeUnit unit, final Scheduler scheduler, final int bufferSize) {
        final long maxAgeInMillis = unit.toMillis(maxAge);
        return OperatorReplay.create(source2, new Func0<ReplayBuffer<T>>(){

            @Override
            public ReplayBuffer<T> call() {
                return new SizeAndTimeBoundReplayBuffer(bufferSize, maxAgeInMillis, scheduler);
            }
        });
    }

    static <T> ConnectableObservable<T> create(Observable<? extends T> source2, final Func0<? extends ReplayBuffer<T>> bufferFactory) {
        final AtomicReference<ReplaySubscriber<T>> curr = new AtomicReference<ReplaySubscriber<T>>();
        Observable.OnSubscribe onSubscribe = new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> child) {
                ReplaySubscriber r;
                while ((r = (ReplaySubscriber)curr.get()) == null) {
                    ReplaySubscriber u = new ReplaySubscriber((ReplayBuffer)bufferFactory.call());
                    u.init();
                    if (!curr.compareAndSet(r, u)) continue;
                    r = u;
                    break;
                }
                InnerProducer inner = new InnerProducer(r, child);
                r.add(inner);
                child.add(inner);
                r.buffer.replay(inner);
                child.setProducer(inner);
            }
        };
        return new OperatorReplay<T>(onSubscribe, source2, curr, bufferFactory);
    }

    private OperatorReplay(Observable.OnSubscribe<T> onSubscribe, Observable<? extends T> source2, AtomicReference<ReplaySubscriber<T>> current, Func0<? extends ReplayBuffer<T>> bufferFactory) {
        super(onSubscribe);
        this.source = source2;
        this.current = current;
        this.bufferFactory = bufferFactory;
    }

    @Override
    public void unsubscribe() {
        this.current.lazySet(null);
    }

    @Override
    public boolean isUnsubscribed() {
        ReplaySubscriber<T> ps = this.current.get();
        return ps == null || ps.isUnsubscribed();
    }

    @Override
    public void connect(Action1<? super Subscription> connection) {
        ReplaySubscriber<T> ps;
        while ((ps = this.current.get()) == null || ps.isUnsubscribed()) {
            ReplaySubscriber<T> u = new ReplaySubscriber<T>(this.bufferFactory.call());
            u.init();
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        boolean doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        connection.call(ps);
        if (doConnect) {
            this.source.unsafeSubscribe(ps);
        }
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = 3457957419649567404L;
        final Scheduler scheduler;
        final long maxAgeInMillis;
        final int limit;

        public SizeAndTimeBoundReplayBuffer(int limit2, long maxAgeInMillis, Scheduler scheduler) {
            this.scheduler = scheduler;
            this.limit = limit2;
            this.maxAgeInMillis = maxAgeInMillis;
        }

        @Override
        Object enterTransform(Object value) {
            return new Timestamped<Object>(this.scheduler.now(), value);
        }

        @Override
        Object leaveTransform(Object value) {
            return ((Timestamped)value).getValue();
        }

        @Override
        Node getInitialHead() {
            Object o;
            Object v;
            long timeLimit = this.scheduler.now() - this.maxAgeInMillis;
            Node prev2 = (Node)this.get();
            for (Node next2 = (Node)prev2.get(); next2 != null && !NotificationLite.isCompleted(v = this.leaveTransform(o = next2.value)) && !NotificationLite.isError(v) && ((Timestamped)o).getTimestampMillis() <= timeLimit; next2 = (Node)next2.get()) {
                prev2 = next2;
            }
            return prev2;
        }

        @Override
        void truncate() {
            long timeLimit = this.scheduler.now() - this.maxAgeInMillis;
            Node prev2 = (Node)this.get();
            Node next2 = (Node)prev2.get();
            int e2 = 0;
            while (next2 != null) {
                if (this.size > this.limit) {
                    ++e2;
                    --this.size;
                    prev2 = next2;
                    next2 = (Node)next2.get();
                    continue;
                }
                Timestamped v = (Timestamped)next2.value;
                if (v.getTimestampMillis() > timeLimit) break;
                ++e2;
                --this.size;
                prev2 = next2;
                next2 = (Node)next2.get();
            }
            if (e2 != 0) {
                this.setFirst(prev2);
            }
        }

        @Override
        void truncateFinal() {
            Timestamped v;
            long timeLimit = this.scheduler.now() - this.maxAgeInMillis;
            Node prev2 = (Node)this.get();
            int e2 = 0;
            for (Node next2 = (Node)prev2.get(); next2 != null && this.size > 1 && (v = (Timestamped)next2.value).getTimestampMillis() <= timeLimit; next2 = (Node)next2.get()) {
                ++e2;
                --this.size;
                prev2 = next2;
            }
            if (e2 != 0) {
                this.setFirst(prev2);
            }
        }
    }

    static final class SizeBoundReplayBuffer<T>
    extends BoundedReplayBuffer<T> {
        private static final long serialVersionUID = -5898283885385201806L;
        final int limit;

        public SizeBoundReplayBuffer(int limit2) {
            this.limit = limit2;
        }

        @Override
        void truncate() {
            if (this.size > this.limit) {
                this.removeFirst();
            }
        }
    }

    static class BoundedReplayBuffer<T>
    extends AtomicReference<Node>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 2346567790059478686L;
        Node tail;
        int size;
        long index;

        public BoundedReplayBuffer() {
            Node n;
            this.tail = n = new Node(null, 0L);
            this.set(n);
        }

        final void addLast(Node n) {
            this.tail.set(n);
            this.tail = n;
            ++this.size;
        }

        final void removeFirst() {
            Node head = (Node)this.get();
            Node next2 = (Node)head.get();
            if (next2 == null) {
                throw new IllegalStateException("Empty list!");
            }
            --this.size;
            this.setFirst(next2);
        }

        final void removeSome(int n) {
            Node head = (Node)this.get();
            while (n > 0) {
                head = (Node)head.get();
                --n;
                --this.size;
            }
            this.setFirst(head);
        }

        final void setFirst(Node n) {
            this.set(n);
        }

        Node getInitialHead() {
            return (Node)this.get();
        }

        @Override
        public final void next(T value) {
            Object o = this.enterTransform(NotificationLite.next(value));
            Node n = new Node(o, ++this.index);
            this.addLast(n);
            this.truncate();
        }

        @Override
        public final void error(Throwable e2) {
            Object o = this.enterTransform(NotificationLite.error(e2));
            Node n = new Node(o, ++this.index);
            this.addLast(n);
            this.truncateFinal();
        }

        @Override
        public final void complete() {
            Object o = this.enterTransform(NotificationLite.completed());
            Node n = new Node(o, ++this.index);
            this.addLast(n);
            this.truncateFinal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void replay(InnerProducer<T> output) {
            InnerProducer<T> innerProducer = output;
            synchronized (innerProducer) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            while (!output.isUnsubscribed()) {
                Node v;
                long e2;
                Node node2 = (Node)output.index();
                if (node2 == null) {
                    node2 = this.getInitialHead();
                    output.index = node2;
                    output.addTotalRequested(node2.index);
                }
                if (output.isUnsubscribed()) {
                    return;
                }
                Subscriber child = output.child;
                if (child == null) {
                    return;
                }
                long r = output.get();
                for (e2 = 0L; e2 != r && (v = (Node)node2.get()) != null; ++e2) {
                    Object o = this.leaveTransform(v.value);
                    try {
                        if (NotificationLite.accept(child, o)) {
                            output.index = null;
                            return;
                        }
                    }
                    catch (Throwable err) {
                        output.index = null;
                        Exceptions.throwIfFatal(err);
                        output.unsubscribe();
                        if (!NotificationLite.isError(o) && !NotificationLite.isCompleted(o)) {
                            child.onError(OnErrorThrowable.addValueAsLastCause(err, NotificationLite.getValue(o)));
                        }
                        return;
                    }
                    node2 = v;
                    if (!output.isUnsubscribed()) continue;
                    return;
                }
                if (e2 != 0L) {
                    output.index = node2;
                    if (r != Long.MAX_VALUE) {
                        output.produced(e2);
                    }
                }
                InnerProducer<T> innerProducer2 = output;
                synchronized (innerProducer2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
            return;
        }

        Object enterTransform(Object value) {
            return value;
        }

        Object leaveTransform(Object value) {
            return value;
        }

        void truncate() {
        }

        void truncateFinal() {
        }

        final void collect(Collection<? super T> output) {
            Object o;
            Object v;
            Node next2;
            Node n = this.getInitialHead();
            while ((next2 = (Node)n.get()) != null && !NotificationLite.isCompleted(v = this.leaveTransform(o = next2.value)) && !NotificationLite.isError(v)) {
                output.add(NotificationLite.getValue(v));
                n = next2;
            }
        }

        boolean hasError() {
            return this.tail.value != null && NotificationLite.isError(this.leaveTransform(this.tail.value));
        }

        boolean hasCompleted() {
            return this.tail.value != null && NotificationLite.isCompleted(this.leaveTransform(this.tail.value));
        }
    }

    static final class Node
    extends AtomicReference<Node> {
        private static final long serialVersionUID = 245354315435971818L;
        final Object value;
        final long index;

        public Node(Object value, long index2) {
            this.value = value;
            this.index = index2;
        }
    }

    static final class UnboundedReplayBuffer<T>
    extends ArrayList<Object>
    implements ReplayBuffer<T> {
        private static final long serialVersionUID = 7063189396499112664L;
        volatile int size;

        public UnboundedReplayBuffer(int capacityHint) {
            super(capacityHint);
        }

        @Override
        public void next(T value) {
            this.add(NotificationLite.next(value));
            ++this.size;
        }

        @Override
        public void error(Throwable e2) {
            this.add(NotificationLite.error(e2));
            ++this.size;
        }

        @Override
        public void complete() {
            this.add(NotificationLite.completed());
            ++this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replay(InnerProducer<T> output) {
            InnerProducer<T> innerProducer = output;
            synchronized (innerProducer) {
                if (output.emitting) {
                    output.missed = true;
                    return;
                }
                output.emitting = true;
            }
            while (!output.isUnsubscribed()) {
                long e2;
                int sourceIndex = this.size;
                Integer destinationIndexObject = (Integer)output.index();
                int destinationIndex = destinationIndexObject != null ? destinationIndexObject : 0;
                Subscriber child = output.child;
                if (child == null) {
                    return;
                }
                long r = output.get();
                for (e2 = 0L; e2 != r && destinationIndex < sourceIndex; ++destinationIndex, ++e2) {
                    Object o = this.get(destinationIndex);
                    try {
                        if (NotificationLite.accept(child, o)) {
                            return;
                        }
                    }
                    catch (Throwable err) {
                        Exceptions.throwIfFatal(err);
                        output.unsubscribe();
                        if (!NotificationLite.isError(o) && !NotificationLite.isCompleted(o)) {
                            child.onError(OnErrorThrowable.addValueAsLastCause(err, NotificationLite.getValue(o)));
                        }
                        return;
                    }
                    if (!output.isUnsubscribed()) continue;
                    return;
                }
                if (e2 != 0L) {
                    output.index = destinationIndex;
                    if (r != Long.MAX_VALUE) {
                        output.produced(e2);
                    }
                }
                InnerProducer<T> innerProducer2 = output;
                synchronized (innerProducer2) {
                    if (!output.missed) {
                        output.emitting = false;
                        return;
                    }
                    output.missed = false;
                }
            }
            return;
        }
    }

    static interface ReplayBuffer<T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void replay(InnerProducer<T> var1);
    }

    static final class InnerProducer<T>
    extends AtomicLong
    implements Producer,
    Subscription {
        private static final long serialVersionUID = -4453897557930727610L;
        final ReplaySubscriber<T> parent;
        Subscriber<? super T> child;
        Object index;
        final AtomicLong totalRequested;
        boolean emitting;
        boolean missed;
        static final long UNSUBSCRIBED = Long.MIN_VALUE;

        public InnerProducer(ReplaySubscriber<T> parent, Subscriber<? super T> child) {
            this.parent = parent;
            this.child = child;
            this.totalRequested = new AtomicLong();
        }

        @Override
        public void request(long n) {
            long u;
            long r;
            if (n < 0L) {
                return;
            }
            do {
                if ((r = this.get()) == Long.MIN_VALUE) {
                    return;
                }
                if (r >= 0L && n == 0L) {
                    return;
                }
                u = r + n;
                if (u >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!this.compareAndSet(r, u));
            this.addTotalRequested(n);
            this.parent.manageRequests(this);
            this.parent.buffer.replay(this);
        }

        void addTotalRequested(long n) {
            long u;
            long r;
            do {
                if ((u = (r = this.totalRequested.get()) + n) >= 0L) continue;
                u = Long.MAX_VALUE;
            } while (!this.totalRequested.compareAndSet(r, u));
        }

        public long produced(long n) {
            long u;
            long r;
            if (n <= 0L) {
                throw new IllegalArgumentException("Cant produce zero or less");
            }
            do {
                if ((r = this.get()) == Long.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                u = r - n;
                if (u >= 0L) continue;
                throw new IllegalStateException("More produced (" + n + ") than requested (" + r + ")");
            } while (!this.compareAndSet(r, u));
            return u;
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get() == Long.MIN_VALUE;
        }

        @Override
        public void unsubscribe() {
            long r = this.get();
            if (r != Long.MIN_VALUE && (r = this.getAndSet(Long.MIN_VALUE)) != Long.MIN_VALUE) {
                this.parent.remove(this);
                this.parent.manageRequests(this);
                this.child = null;
            }
        }

        <U> U index() {
            return (U)this.index;
        }
    }

    static final class ReplaySubscriber<T>
    extends Subscriber<T>
    implements Subscription {
        final ReplayBuffer<T> buffer;
        boolean done;
        static final InnerProducer[] EMPTY = new InnerProducer[0];
        static final InnerProducer[] TERMINATED = new InnerProducer[0];
        volatile boolean terminated;
        final OpenHashSet<InnerProducer<T>> producers;
        InnerProducer<T>[] producersCache;
        volatile long producersVersion;
        long producersCacheVersion;
        final AtomicBoolean shouldConnect;
        boolean emitting;
        boolean missed;
        long maxChildRequested;
        long maxUpstreamRequested;
        volatile Producer producer;
        List<InnerProducer<T>> coordinationQueue;
        boolean coordinateAll;

        public ReplaySubscriber(ReplayBuffer<T> buffer) {
            this.buffer = buffer;
            this.producers = new OpenHashSet();
            this.producersCache = EMPTY;
            this.shouldConnect = new AtomicBoolean();
            this.request(0L);
        }

        void init() {
            this.add(Subscriptions.create(new Action0(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void call() {
                    if (!ReplaySubscriber.this.terminated) {
                        OpenHashSet openHashSet = ReplaySubscriber.this.producers;
                        synchronized (openHashSet) {
                            if (!ReplaySubscriber.this.terminated) {
                                ReplaySubscriber.this.producers.terminate();
                                ++ReplaySubscriber.this.producersVersion;
                                ReplaySubscriber.this.terminated = true;
                            }
                        }
                    }
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean add(InnerProducer<T> producer) {
            if (producer == null) {
                throw new NullPointerException();
            }
            if (this.terminated) {
                return false;
            }
            OpenHashSet<InnerProducer<T>> openHashSet = this.producers;
            synchronized (openHashSet) {
                if (this.terminated) {
                    return false;
                }
                this.producers.add(producer);
                ++this.producersVersion;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(InnerProducer<T> producer) {
            if (this.terminated) {
                return;
            }
            OpenHashSet<InnerProducer<T>> openHashSet = this.producers;
            synchronized (openHashSet) {
                if (this.terminated) {
                    return;
                }
                this.producers.remove(producer);
                if (this.producers.isEmpty()) {
                    this.producersCache = EMPTY;
                }
                ++this.producersVersion;
            }
        }

        @Override
        public void setProducer(Producer p) {
            Producer p0 = this.producer;
            if (p0 != null) {
                throw new IllegalStateException("Only a single producer can be set on a Subscriber.");
            }
            this.producer = p;
            this.manageRequests(null);
            this.replay();
        }

        @Override
        public void onNext(T t) {
            if (!this.done) {
                this.buffer.next(t);
                this.replay();
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (!this.done) {
                this.done = true;
                try {
                    this.buffer.error(e2);
                    this.replay();
                }
                finally {
                    this.unsubscribe();
                }
            }
        }

        @Override
        public void onCompleted() {
            if (!this.done) {
                this.done = true;
                try {
                    this.buffer.complete();
                    this.replay();
                }
                finally {
                    this.unsubscribe();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        void manageRequests(InnerProducer<T> inner) {
            long maxTotalRequested;
            if (this.isUnsubscribed()) {
                return;
            }
            ReplaySubscriber replaySubscriber = this;
            synchronized (replaySubscriber) {
                if (this.emitting) {
                    if (inner != null) {
                        List<InnerProducer<T>> q = this.coordinationQueue;
                        if (q == null) {
                            q = new ArrayList<InnerProducer<T>>();
                            this.coordinationQueue = q;
                        }
                        q.add(inner);
                    } else {
                        this.coordinateAll = true;
                    }
                    this.missed = true;
                    return;
                }
                this.emitting = true;
            }
            long ri = this.maxChildRequested;
            if (inner != null) {
                maxTotalRequested = Math.max(ri, inner.totalRequested.get());
            } else {
                void var9_13;
                InnerProducer<T>[] a;
                maxTotalRequested = ri;
                InnerProducer<T>[] innerProducerArray = a = this.copyProducers();
                int n = innerProducerArray.length;
                boolean bl = false;
                while (var9_13 < n) {
                    InnerProducer<T> rp = innerProducerArray[var9_13];
                    if (rp != null) {
                        maxTotalRequested = Math.max(maxTotalRequested, rp.totalRequested.get());
                    }
                    ++var9_13;
                }
            }
            this.makeRequest(maxTotalRequested, ri);
            while (!this.isUnsubscribed()) {
                void all2;
                List<InnerProducer<T>> q;
                ReplaySubscriber replaySubscriber2 = this;
                synchronized (replaySubscriber2) {
                    if (!this.missed) {
                        this.emitting = false;
                        return;
                    }
                    this.missed = false;
                    q = this.coordinationQueue;
                    this.coordinationQueue = null;
                    boolean all22 = this.coordinateAll;
                    this.coordinateAll = false;
                }
                maxTotalRequested = ri = this.maxChildRequested;
                if (q != null) {
                    for (InnerProducer innerProducer : q) {
                        maxTotalRequested = Math.max(maxTotalRequested, innerProducer.totalRequested.get());
                    }
                }
                if (all2 != false) {
                    InnerProducer<T>[] a;
                    for (InnerProducer<T> rp : a = this.copyProducers()) {
                        if (rp == null) continue;
                        maxTotalRequested = Math.max(maxTotalRequested, rp.totalRequested.get());
                    }
                }
                this.makeRequest(maxTotalRequested, ri);
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InnerProducer<T>[] copyProducers() {
            OpenHashSet<InnerProducer<T>> openHashSet = this.producers;
            synchronized (openHashSet) {
                InnerProducer<T>[] a = this.producers.values();
                int n = a.length;
                InnerProducer[] result = new InnerProducer[n];
                System.arraycopy(a, 0, result, 0, n);
                return result;
            }
        }

        void makeRequest(long maxTotalRequests, long previousTotalRequests) {
            long ur = this.maxUpstreamRequested;
            Producer p = this.producer;
            long diff2 = maxTotalRequests - previousTotalRequests;
            if (diff2 != 0L) {
                this.maxChildRequested = maxTotalRequests;
                if (p != null) {
                    if (ur != 0L) {
                        this.maxUpstreamRequested = 0L;
                        p.request(ur + diff2);
                    } else {
                        p.request(diff2);
                    }
                } else {
                    long u = ur + diff2;
                    if (u < 0L) {
                        u = Long.MAX_VALUE;
                    }
                    this.maxUpstreamRequested = u;
                }
            } else if (ur != 0L && p != null) {
                this.maxUpstreamRequested = 0L;
                p.request(ur);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void replay() {
            InnerProducer<T>[] pc = this.producersCache;
            if (this.producersCacheVersion != this.producersVersion) {
                OpenHashSet<InnerProducer<T>> openHashSet = this.producers;
                synchronized (openHashSet) {
                    pc = this.producersCache;
                    InnerProducer<T>[] a = this.producers.values();
                    int n = a.length;
                    if (pc.length != n) {
                        this.producersCache = pc = new InnerProducer[n];
                    }
                    System.arraycopy(a, 0, pc, 0, n);
                    this.producersCacheVersion = this.producersVersion;
                }
            }
            ReplayBuffer<T> b = this.buffer;
            for (InnerProducer<T> rp : pc) {
                if (rp == null) continue;
                b.replay(rp);
            }
        }
    }
}

