/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.Action1;
import io.mantisrx.mql.shaded.rx.internal.operators.BackpressureUtils;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import java.util.concurrent.atomic.AtomicLong;

public class OperatorOnBackpressureDrop<T>
implements Observable.Operator<T, T> {
    final Action1<? super T> onDrop;

    public static <T> OperatorOnBackpressureDrop<T> instance() {
        return Holder.INSTANCE;
    }

    OperatorOnBackpressureDrop() {
        this(null);
    }

    public OperatorOnBackpressureDrop(Action1<? super T> onDrop) {
        this.onDrop = onDrop;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final AtomicLong requested = new AtomicLong();
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                BackpressureUtils.getAndAddRequest(requested, n);
            }
        });
        return new Subscriber<T>(child){
            boolean done;

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                if (!this.done) {
                    this.done = true;
                    child.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e2) {
                if (!this.done) {
                    this.done = true;
                    child.onError(e2);
                } else {
                    RxJavaHooks.onError(e2);
                }
            }

            @Override
            public void onNext(T t) {
                if (this.done) {
                    return;
                }
                if (requested.get() > 0L) {
                    child.onNext(t);
                    requested.decrementAndGet();
                } else if (OperatorOnBackpressureDrop.this.onDrop != null) {
                    try {
                        OperatorOnBackpressureDrop.this.onDrop.call(t);
                    }
                    catch (Throwable e2) {
                        Exceptions.throwOrReport(e2, this, t);
                    }
                }
            }
        };
    }

    static final class Holder {
        static final OperatorOnBackpressureDrop<Object> INSTANCE = new OperatorOnBackpressureDrop();

        Holder() {
        }
    }
}

