/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.exceptions.OnErrorThrowable;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;

public class OperatorCast<T, R>
implements Observable.Operator<R, T> {
    final Class<R> castClass;

    public OperatorCast(Class<R> castClass) {
        this.castClass = castClass;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> o) {
        CastSubscriber parent = new CastSubscriber(o, this.castClass);
        o.add(parent);
        return parent;
    }

    static final class CastSubscriber<T, R>
    extends Subscriber<T> {
        final Subscriber<? super R> actual;
        final Class<R> castClass;
        boolean done;

        public CastSubscriber(Subscriber<? super R> actual, Class<R> castClass) {
            this.actual = actual;
            this.castClass = castClass;
        }

        @Override
        public void onNext(T t) {
            R result;
            try {
                result = this.castClass.cast(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(OnErrorThrowable.addValueAsLastCause(ex, t));
                return;
            }
            this.actual.onNext(result);
        }

        @Override
        public void onError(Throwable e2) {
            if (this.done) {
                RxJavaHooks.onError(e2);
                return;
            }
            this.done = true;
            this.actual.onError(e2);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.actual.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            this.actual.setProducer(p);
        }
    }
}

