/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.exceptions.OnErrorThrowable;
import io.mantisrx.mql.shaded.rx.functions.Func1;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;

public final class OnSubscribeFilter<T>
implements Observable.OnSubscribe<T> {
    final Observable<T> source;
    final Func1<? super T, Boolean> predicate;

    public OnSubscribeFilter(Observable<T> source2, Func1<? super T, Boolean> predicate) {
        this.source = source2;
        this.predicate = predicate;
    }

    @Override
    public void call(Subscriber<? super T> child) {
        FilterSubscriber<? super T> parent = new FilterSubscriber<T>(child, this.predicate);
        child.add(parent);
        this.source.unsafeSubscribe(parent);
    }

    static final class FilterSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final Func1<? super T, Boolean> predicate;
        boolean done;

        public FilterSubscriber(Subscriber<? super T> actual, Func1<? super T, Boolean> predicate) {
            this.actual = actual;
            this.predicate = predicate;
            this.request(0L);
        }

        @Override
        public void onNext(T t) {
            boolean result;
            try {
                result = this.predicate.call(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(OnErrorThrowable.addValueAsLastCause(ex, t));
                return;
            }
            if (result) {
                this.actual.onNext(t);
            } else {
                this.request(1L);
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (this.done) {
                RxJavaHooks.onError(e2);
                return;
            }
            this.done = true;
            this.actual.onError(e2);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.actual.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            super.setProducer(p);
            this.actual.setProducer(p);
        }
    }
}

