/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.functions.Action1;
import io.mantisrx.mql.shaded.rx.observables.ConnectableObservable;
import io.mantisrx.mql.shaded.rx.observers.Subscribers;
import java.util.concurrent.atomic.AtomicInteger;

public final class OnSubscribeAutoConnect<T>
extends AtomicInteger
implements Observable.OnSubscribe<T> {
    final ConnectableObservable<? extends T> source;
    final int numberOfSubscribers;
    final Action1<? super Subscription> connection;

    public OnSubscribeAutoConnect(ConnectableObservable<? extends T> source2, int numberOfSubscribers, Action1<? super Subscription> connection) {
        if (numberOfSubscribers <= 0) {
            throw new IllegalArgumentException("numberOfSubscribers > 0 required");
        }
        this.source = source2;
        this.numberOfSubscribers = numberOfSubscribers;
        this.connection = connection;
    }

    @Override
    public void call(Subscriber<? super T> child) {
        this.source.unsafeSubscribe(Subscribers.wrap(child));
        if (this.incrementAndGet() == this.numberOfSubscribers) {
            this.source.connect(this.connection);
        }
    }
}

