/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Completable;
import io.mantisrx.mql.shaded.rx.CompletableSubscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.internal.operators.CompletableOnSubscribeMerge;
import io.mantisrx.mql.shaded.rx.subscriptions.CompositeSubscription;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableOnSubscribeMergeDelayErrorArray
implements Completable.OnSubscribe {
    final Completable[] sources;

    public CompletableOnSubscribeMergeDelayErrorArray(Completable[] sources) {
        this.sources = sources;
    }

    @Override
    public void call(final CompletableSubscriber s) {
        final CompositeSubscription set2 = new CompositeSubscription();
        final AtomicInteger wip = new AtomicInteger(this.sources.length + 1);
        final ConcurrentLinkedQueue<Throwable> q = new ConcurrentLinkedQueue<Throwable>();
        s.onSubscribe(set2);
        for (Completable c : this.sources) {
            if (set2.isUnsubscribed()) {
                return;
            }
            if (c == null) {
                q.offer(new NullPointerException("A completable source is null"));
                wip.decrementAndGet();
                continue;
            }
            c.unsafeSubscribe(new CompletableSubscriber(){

                @Override
                public void onSubscribe(Subscription d) {
                    set2.add(d);
                }

                @Override
                public void onError(Throwable e2) {
                    q.offer(e2);
                    this.tryTerminate();
                }

                @Override
                public void onCompleted() {
                    this.tryTerminate();
                }

                void tryTerminate() {
                    if (wip.decrementAndGet() == 0) {
                        if (q.isEmpty()) {
                            s.onCompleted();
                        } else {
                            s.onError(CompletableOnSubscribeMerge.collectErrors(q));
                        }
                    }
                }
            });
        }
        if (wip.decrementAndGet() == 0) {
            if (q.isEmpty()) {
                s.onCompleted();
            } else {
                s.onError(CompletableOnSubscribeMerge.collectErrors(q));
            }
        }
    }
}

