/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Completable;
import io.mantisrx.mql.shaded.rx.CompletableEmitter;
import io.mantisrx.mql.shaded.rx.CompletableSubscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.Action1;
import io.mantisrx.mql.shaded.rx.functions.Cancellable;
import io.mantisrx.mql.shaded.rx.internal.subscriptions.CancellableSubscription;
import io.mantisrx.mql.shaded.rx.internal.subscriptions.SequentialSubscription;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CompletableFromEmitter
implements Completable.OnSubscribe {
    final Action1<CompletableEmitter> producer;

    public CompletableFromEmitter(Action1<CompletableEmitter> producer) {
        this.producer = producer;
    }

    @Override
    public void call(CompletableSubscriber t) {
        FromEmitter emitter = new FromEmitter(t);
        t.onSubscribe(emitter);
        try {
            this.producer.call(emitter);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            emitter.onError(ex);
        }
    }

    static final class FromEmitter
    extends AtomicBoolean
    implements CompletableEmitter,
    Subscription {
        private static final long serialVersionUID = 5539301318568668881L;
        final CompletableSubscriber actual;
        final SequentialSubscription resource;

        public FromEmitter(CompletableSubscriber actual) {
            this.actual = actual;
            this.resource = new SequentialSubscription();
        }

        @Override
        public void onCompleted() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.actual.onCompleted();
                }
                finally {
                    this.resource.unsubscribe();
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.compareAndSet(false, true)) {
                try {
                    this.actual.onError(t);
                }
                finally {
                    this.resource.unsubscribe();
                }
            } else {
                RxJavaHooks.onError(t);
            }
        }

        @Override
        public void setSubscription(Subscription s) {
            this.resource.update(s);
        }

        @Override
        public void setCancellation(Cancellable c) {
            this.setSubscription(new CancellableSubscription(c));
        }

        @Override
        public void unsubscribe() {
            if (this.compareAndSet(false, true)) {
                this.resource.unsubscribe();
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get();
        }
    }
}

