/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.exceptions;

import io.mantisrx.mql.shaded.rx.Observer;
import io.mantisrx.mql.shaded.rx.SingleSubscriber;
import io.mantisrx.mql.shaded.rx.exceptions.CompositeException;
import io.mantisrx.mql.shaded.rx.exceptions.OnCompletedFailedException;
import io.mantisrx.mql.shaded.rx.exceptions.OnErrorFailedException;
import io.mantisrx.mql.shaded.rx.exceptions.OnErrorNotImplementedException;
import io.mantisrx.mql.shaded.rx.exceptions.OnErrorThrowable;
import java.util.HashSet;
import java.util.List;

public final class Exceptions {
    private static final int MAX_DEPTH = 25;

    private Exceptions() {
        throw new IllegalStateException("No instances!");
    }

    public static RuntimeException propagate(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    public static void throwIfFatal(Throwable t) {
        if (t instanceof OnErrorNotImplementedException) {
            throw (OnErrorNotImplementedException)t;
        }
        if (t instanceof OnErrorFailedException) {
            throw (OnErrorFailedException)t;
        }
        if (t instanceof OnCompletedFailedException) {
            throw (OnCompletedFailedException)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof LinkageError) {
            throw (LinkageError)t;
        }
    }

    public static void addCause(Throwable e2, Throwable cause) {
        HashSet<Throwable> seenCauses = new HashSet<Throwable>();
        int i = 0;
        while (e2.getCause() != null) {
            if (i++ >= 25) {
                return;
            }
            if (seenCauses.contains((e2 = e2.getCause()).getCause())) break;
            seenCauses.add(e2.getCause());
        }
        try {
            e2.initCause(cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Throwable getFinalCause(Throwable e2) {
        int i = 0;
        while (e2.getCause() != null) {
            if (i++ >= 25) {
                return new RuntimeException("Stack too deep to get final cause");
            }
            e2 = e2.getCause();
        }
        return e2;
    }

    public static void throwIfAny(List<? extends Throwable> exceptions) {
        if (exceptions != null && !exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                Throwable t = exceptions.get(0);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
            throw new CompositeException(exceptions);
        }
    }

    public static void throwOrReport(Throwable t, Observer<?> o, Object value) {
        Exceptions.throwIfFatal(t);
        o.onError(OnErrorThrowable.addValueAsLastCause(t, value));
    }

    public static void throwOrReport(Throwable t, SingleSubscriber<?> o, Object value) {
        Exceptions.throwIfFatal(t);
        o.onError(OnErrorThrowable.addValueAsLastCause(t, value));
    }

    public static void throwOrReport(Throwable t, Observer<?> o) {
        Exceptions.throwIfFatal(t);
        o.onError(t);
    }

    public static void throwOrReport(Throwable throwable, SingleSubscriber<?> subscriber2) {
        Exceptions.throwIfFatal(throwable);
        subscriber2.onError(throwable);
    }
}

