/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.subscriptions;

import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.subscriptions.BooleanSubscription;
import io.mantisrx.mql.shaded.rx.subscriptions.CompositeSubscription;
import java.util.concurrent.Future;

public final class Subscriptions {
    private static final Unsubscribed UNSUBSCRIBED = new Unsubscribed();

    private Subscriptions() {
        throw new IllegalStateException("No instances!");
    }

    public static Subscription empty() {
        return BooleanSubscription.create();
    }

    public static Subscription unsubscribed() {
        return UNSUBSCRIBED;
    }

    public static Subscription create(Action0 unsubscribe2) {
        return BooleanSubscription.create(unsubscribe2);
    }

    public static Subscription from(Future<?> f) {
        return new FutureSubscription(f);
    }

    public static CompositeSubscription from(Subscription ... subscriptions) {
        return new CompositeSubscription(subscriptions);
    }

    static final class Unsubscribed
    implements Subscription {
        Unsubscribed() {
        }

        @Override
        public void unsubscribe() {
        }

        @Override
        public boolean isUnsubscribed() {
            return true;
        }
    }

    static final class FutureSubscription
    implements Subscription {
        final Future<?> f;

        public FutureSubscription(Future<?> f) {
            this.f = f;
        }

        @Override
        public void unsubscribe() {
            this.f.cancel(true);
        }

        @Override
        public boolean isUnsubscribed() {
            return this.f.isCancelled();
        }
    }
}

