/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.schedulers;

import io.mantisrx.mql.shaded.rx.Scheduler;
import io.mantisrx.mql.shaded.rx.internal.schedulers.ExecutorScheduler;
import io.mantisrx.mql.shaded.rx.internal.schedulers.GenericScheduledExecutorService;
import io.mantisrx.mql.shaded.rx.internal.schedulers.ImmediateScheduler;
import io.mantisrx.mql.shaded.rx.internal.schedulers.SchedulerLifecycle;
import io.mantisrx.mql.shaded.rx.internal.schedulers.TrampolineScheduler;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaPlugins;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaSchedulersHook;
import io.mantisrx.mql.shaded.rx.schedulers.TestScheduler;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public final class Schedulers {
    private final Scheduler computationScheduler;
    private final Scheduler ioScheduler;
    private final Scheduler newThreadScheduler;
    private static final AtomicReference<Schedulers> INSTANCE = new AtomicReference();

    private static Schedulers getInstance() {
        Schedulers current;
        while ((current = INSTANCE.get()) == null) {
            current = new Schedulers();
            if (INSTANCE.compareAndSet(null, current)) {
                return current;
            }
            current.shutdownInstance();
        }
        return current;
    }

    private Schedulers() {
        RxJavaSchedulersHook hook = RxJavaPlugins.getInstance().getSchedulersHook();
        Scheduler c = hook.getComputationScheduler();
        this.computationScheduler = c != null ? c : RxJavaSchedulersHook.createComputationScheduler();
        Scheduler io2 = hook.getIOScheduler();
        this.ioScheduler = io2 != null ? io2 : RxJavaSchedulersHook.createIoScheduler();
        Scheduler nt2 = hook.getNewThreadScheduler();
        this.newThreadScheduler = nt2 != null ? nt2 : RxJavaSchedulersHook.createNewThreadScheduler();
    }

    public static Scheduler immediate() {
        return ImmediateScheduler.INSTANCE;
    }

    public static Scheduler trampoline() {
        return TrampolineScheduler.INSTANCE;
    }

    public static Scheduler newThread() {
        return RxJavaHooks.onNewThreadScheduler(Schedulers.getInstance().newThreadScheduler);
    }

    public static Scheduler computation() {
        return RxJavaHooks.onComputationScheduler(Schedulers.getInstance().computationScheduler);
    }

    public static Scheduler io() {
        return RxJavaHooks.onIOScheduler(Schedulers.getInstance().ioScheduler);
    }

    public static TestScheduler test() {
        return new TestScheduler();
    }

    public static Scheduler from(Executor executor) {
        return new ExecutorScheduler(executor);
    }

    public static void reset() {
        Schedulers s = INSTANCE.getAndSet(null);
        if (s != null) {
            s.shutdownInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() {
        Schedulers s = Schedulers.getInstance();
        s.startInstance();
        Schedulers schedulers = s;
        synchronized (schedulers) {
            GenericScheduledExecutorService.INSTANCE.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Schedulers s = Schedulers.getInstance();
        s.shutdownInstance();
        Schedulers schedulers = s;
        synchronized (schedulers) {
            GenericScheduledExecutorService.INSTANCE.shutdown();
        }
    }

    synchronized void startInstance() {
        if (this.computationScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.computationScheduler)).start();
        }
        if (this.ioScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.ioScheduler)).start();
        }
        if (this.newThreadScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.newThreadScheduler)).start();
        }
    }

    synchronized void shutdownInstance() {
        if (this.computationScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.computationScheduler)).shutdown();
        }
        if (this.ioScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.ioScheduler)).shutdown();
        }
        if (this.newThreadScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.newThreadScheduler)).shutdown();
        }
    }
}

