/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.observers;

import io.mantisrx.mql.shaded.rx.CompletableSubscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.exceptions.CompositeException;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.exceptions.OnCompletedFailedException;
import io.mantisrx.mql.shaded.rx.exceptions.OnErrorFailedException;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;

public final class SafeCompletableSubscriber
implements CompletableSubscriber,
Subscription {
    final CompletableSubscriber actual;
    Subscription s;
    boolean done;

    public SafeCompletableSubscriber(CompletableSubscriber actual) {
        this.actual = actual;
    }

    @Override
    public void onCompleted() {
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.actual.onCompleted();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw new OnCompletedFailedException(ex);
        }
    }

    @Override
    public void onError(Throwable e2) {
        if (this.done) {
            RxJavaHooks.onError(e2);
            return;
        }
        this.done = true;
        try {
            this.actual.onError(e2);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw new OnErrorFailedException(new CompositeException(e2, ex));
        }
    }

    @Override
    public void onSubscribe(Subscription d) {
        this.s = d;
        try {
            this.actual.onSubscribe(this);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            d.unsubscribe();
            this.onError(ex);
        }
    }

    @Override
    public void unsubscribe() {
        this.s.unsubscribe();
    }

    @Override
    public boolean isUnsubscribed() {
        return this.done || this.s.isUnsubscribed();
    }
}

