/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.util.unsafe;

import io.mantisrx.mql.shaded.rx.internal.util.SuppressAnimalSniffer;
import io.mantisrx.mql.shaded.rx.internal.util.unsafe.SpscArrayQueueL3Pad;
import io.mantisrx.mql.shaded.rx.internal.util.unsafe.UnsafeAccess;

@SuppressAnimalSniffer
public final class SpscArrayQueue<E>
extends SpscArrayQueueL3Pad<E> {
    public SpscArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e2) {
        if (e2 == null) {
            throw new NullPointerException("null elements not allowed");
        }
        Object[] lElementBuffer = this.buffer;
        long index2 = this.producerIndex;
        long offset = this.calcElementOffset(index2);
        if (null != this.lvElement(lElementBuffer, offset)) {
            return false;
        }
        this.soElement(lElementBuffer, offset, e2);
        this.soProducerIndex(index2 + 1L);
        return true;
    }

    @Override
    public E poll() {
        Object[] lElementBuffer = this.buffer;
        long index2 = this.consumerIndex;
        long offset = this.calcElementOffset(index2);
        Object e2 = this.lvElement(lElementBuffer, offset);
        if (null == e2) {
            return null;
        }
        this.soElement(lElementBuffer, offset, null);
        this.soConsumerIndex(index2 + 1L);
        return (E)e2;
    }

    @Override
    public E peek() {
        return this.lvElement(this.calcElementOffset(this.consumerIndex));
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvProducerIndex() == this.lvConsumerIndex();
    }

    private void soProducerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, P_INDEX_OFFSET, v);
    }

    private void soConsumerIndex(long v) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, C_INDEX_OFFSET, v);
    }

    private long lvProducerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, P_INDEX_OFFSET);
    }

    private long lvConsumerIndex() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this, C_INDEX_OFFSET);
    }
}

