/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.subscriptions;

import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.Cancellable;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import java.util.concurrent.atomic.AtomicReference;

public final class CancellableSubscription
extends AtomicReference<Cancellable>
implements Subscription {
    private static final long serialVersionUID = 5718521705281392066L;

    public CancellableSubscription(Cancellable cancellable) {
        super(cancellable);
    }

    @Override
    public boolean isUnsubscribed() {
        return this.get() == null;
    }

    @Override
    public void unsubscribe() {
        Cancellable c;
        if (this.get() != null && (c = (Cancellable)this.getAndSet(null)) != null) {
            try {
                c.cancel();
            }
            catch (Exception ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaHooks.onError(ex);
            }
        }
    }
}

