/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Completable;
import io.mantisrx.mql.shaded.rx.CompletableSubscriber;
import io.mantisrx.mql.shaded.rx.Single;
import io.mantisrx.mql.shaded.rx.SingleSubscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SingleTakeUntilCompletable<T>
implements Single.OnSubscribe<T> {
    final Single.OnSubscribe<T> source;
    final Completable other;

    public SingleTakeUntilCompletable(Single.OnSubscribe<T> source2, Completable other) {
        this.source = source2;
        this.other = other;
    }

    @Override
    public void call(SingleSubscriber<? super T> t) {
        TakeUntilSourceSubscriber<? super T> parent = new TakeUntilSourceSubscriber<T>(t);
        t.add(parent);
        this.other.subscribe(parent);
        this.source.call(parent);
    }

    static final class TakeUntilSourceSubscriber<T>
    extends SingleSubscriber<T>
    implements CompletableSubscriber {
        final SingleSubscriber<? super T> actual;
        final AtomicBoolean once;

        TakeUntilSourceSubscriber(SingleSubscriber<? super T> actual) {
            this.actual = actual;
            this.once = new AtomicBoolean();
        }

        @Override
        public void onSubscribe(Subscription d) {
            this.add(d);
        }

        @Override
        public void onSuccess(T value) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable error) {
            if (this.once.compareAndSet(false, true)) {
                this.unsubscribe();
                this.actual.onError(error);
            } else {
                RxJavaHooks.onError(error);
            }
        }

        @Override
        public void onCompleted() {
            this.onError(new CancellationException("Single::takeUntil(Completable) - Stream was canceled before emitting a terminal event."));
        }
    }
}

