/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Single;
import io.mantisrx.mql.shaded.rx.SingleSubscriber;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.internal.operators.SingleFromObservable;
import io.mantisrx.mql.shaded.rx.internal.producers.SingleProducer;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;

public final class SingleLiftObservableOperator<T, R>
implements Single.OnSubscribe<R> {
    final Single.OnSubscribe<T> source;
    final Observable.Operator<? extends R, ? super T> lift;

    public SingleLiftObservableOperator(Single.OnSubscribe<T> source2, Observable.Operator<? extends R, ? super T> lift2) {
        this.source = source2;
        this.lift = lift2;
    }

    @Override
    public void call(SingleSubscriber<? super R> t) {
        SingleFromObservable.WrapSingleIntoSubscriber<? super R> outputAsSubscriber = new SingleFromObservable.WrapSingleIntoSubscriber<R>(t);
        t.add(outputAsSubscriber);
        try {
            Subscriber inputAsSubscriber = (Subscriber)RxJavaHooks.onSingleLift(this.lift).call(outputAsSubscriber);
            SingleSubscriber<T> input = SingleLiftObservableOperator.wrap(inputAsSubscriber);
            inputAsSubscriber.onStart();
            this.source.call(input);
        }
        catch (Throwable ex) {
            Exceptions.throwOrReport(ex, t);
        }
    }

    public static <T> SingleSubscriber<T> wrap(Subscriber<T> subscriber2) {
        WrapSubscriberIntoSingle<T> parent = new WrapSubscriberIntoSingle<T>(subscriber2);
        subscriber2.add(parent);
        return parent;
    }

    static final class WrapSubscriberIntoSingle<T>
    extends SingleSubscriber<T> {
        final Subscriber<? super T> actual;

        WrapSubscriberIntoSingle(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void onSuccess(T value) {
            this.actual.setProducer(new SingleProducer<T>(this.actual, value));
        }

        @Override
        public void onError(Throwable error) {
            this.actual.onError(error);
        }
    }
}

