/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.Func2;
import io.mantisrx.mql.shaded.rx.observers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicReference;

public final class OperatorWithLatestFrom<T, U, R>
implements Observable.Operator<R, T> {
    final Func2<? super T, ? super U, ? extends R> resultSelector;
    final Observable<? extends U> other;
    static final Object EMPTY = new Object();

    public OperatorWithLatestFrom(Observable<? extends U> other, Func2<? super T, ? super U, ? extends R> resultSelector) {
        this.other = other;
        this.resultSelector = resultSelector;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super R> child) {
        final SerializedSubscriber<R> s = new SerializedSubscriber<R>(child, false);
        child.add(s);
        final AtomicReference<Object> current = new AtomicReference<Object>(EMPTY);
        Subscriber subscriber2 = new Subscriber<T>(s, true){

            @Override
            public void onNext(T t) {
                Object o = current.get();
                if (o != EMPTY) {
                    try {
                        Object u = o;
                        Object result = OperatorWithLatestFrom.this.resultSelector.call(t, u);
                        s.onNext(result);
                    }
                    catch (Throwable e2) {
                        Exceptions.throwOrReport(e2, this);
                    }
                }
            }

            @Override
            public void onError(Throwable e2) {
                s.onError(e2);
                s.unsubscribe();
            }

            @Override
            public void onCompleted() {
                s.onCompleted();
                s.unsubscribe();
            }
        };
        Subscriber otherSubscriber = new Subscriber<U>(){

            @Override
            public void onNext(U t) {
                current.set(t);
            }

            @Override
            public void onError(Throwable e2) {
                s.onError(e2);
                s.unsubscribe();
            }

            @Override
            public void onCompleted() {
                if (current.get() == EMPTY) {
                    s.onCompleted();
                    s.unsubscribe();
                }
            }
        };
        s.add(subscriber2);
        s.add(otherSubscriber);
        this.other.unsafeSubscribe(otherSubscriber);
        return subscriber2;
    }
}

