/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.internal.operators.BackpressureUtils;
import io.mantisrx.mql.shaded.rx.internal.util.atomic.SpscLinkedArrayQueue;
import io.mantisrx.mql.shaded.rx.subjects.Subject;
import io.mantisrx.mql.shaded.rx.subjects.UnicastSubject;
import io.mantisrx.mql.shaded.rx.subscriptions.Subscriptions;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class OperatorWindowWithSize<T>
implements Observable.Operator<Observable<T>, T> {
    final int size;
    final int skip;

    public OperatorWindowWithSize(int size, int skip) {
        this.size = size;
        this.skip = skip;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Observable<T>> child) {
        if (this.skip == this.size) {
            WindowExact parent = new WindowExact(child, this.size);
            child.add(parent.cancel);
            child.setProducer(parent.createProducer());
            return parent;
        }
        if (this.skip > this.size) {
            WindowSkip parent = new WindowSkip(child, this.size, this.skip);
            child.add(parent.cancel);
            child.setProducer(parent.createProducer());
            return parent;
        }
        WindowOverlap parent = new WindowOverlap(child, this.size, this.skip);
        child.add(parent.cancel);
        child.setProducer(parent.createProducer());
        return parent;
    }

    static final class WindowOverlap<T>
    extends Subscriber<T>
    implements Action0 {
        final Subscriber<? super Observable<T>> actual;
        final int size;
        final int skip;
        final AtomicInteger wip;
        final Subscription cancel;
        final ArrayDeque<Subject<T, T>> windows;
        final AtomicLong requested;
        final AtomicInteger drainWip;
        final Queue<Subject<T, T>> queue;
        Throwable error;
        volatile boolean done;
        int index;
        int produced;

        public WindowOverlap(Subscriber<? super Observable<T>> actual, int size, int skip) {
            this.actual = actual;
            this.size = size;
            this.skip = skip;
            this.wip = new AtomicInteger(1);
            this.windows = new ArrayDeque();
            this.drainWip = new AtomicInteger();
            this.requested = new AtomicLong();
            this.cancel = Subscriptions.create(this);
            this.add(this.cancel);
            this.request(0L);
            int maxWindows = (size + (skip - 1)) / skip;
            this.queue = new SpscLinkedArrayQueue<Subject<T, T>>(maxWindows);
        }

        @Override
        public void onNext(T t) {
            int i = this.index;
            ArrayDeque<Subject<T, T>> q = this.windows;
            if (i == 0 && !this.actual.isUnsubscribed()) {
                this.wip.getAndIncrement();
                UnicastSubject w = UnicastSubject.create(16, this);
                q.offer(w);
                this.queue.offer(w);
                this.drain();
            }
            for (Subject<T, T> w : this.windows) {
                w.onNext(t);
            }
            int p = this.produced + 1;
            if (p == this.size) {
                Subject<T, T> w;
                this.produced = p - this.skip;
                w = q.poll();
                if (w != null) {
                    w.onCompleted();
                }
            } else {
                this.produced = p;
            }
            this.index = ++i == this.skip ? 0 : i;
        }

        @Override
        public void onError(Throwable e2) {
            for (Subject<T, T> w : this.windows) {
                w.onError(e2);
            }
            this.windows.clear();
            this.error = e2;
            this.done = true;
            this.drain();
        }

        @Override
        public void onCompleted() {
            for (Subject<T, T> w : this.windows) {
                w.onCompleted();
            }
            this.windows.clear();
            this.done = true;
            this.drain();
        }

        Producer createProducer() {
            return new WindowOverlapProducer();
        }

        @Override
        public void call() {
            if (this.wip.decrementAndGet() == 0) {
                this.unsubscribe();
            }
        }

        void drain() {
            AtomicInteger dw = this.drainWip;
            if (dw.getAndIncrement() != 0) {
                return;
            }
            Subscriber<Observable<Subject<T, T>>> a = this.actual;
            Queue<Subject<T, T>> q = this.queue;
            int missed = 1;
            do {
                long e2;
                long r = this.requested.get();
                for (e2 = 0L; e2 != r; ++e2) {
                    boolean empty2;
                    boolean d = this.done;
                    Subject<T, T> v = q.poll();
                    boolean bl = empty2 = v == null;
                    if (this.checkTerminated(d, empty2, a, q)) {
                        return;
                    }
                    if (empty2) break;
                    a.onNext(v);
                }
                if (e2 == r && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                if (e2 == 0L || r == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e2);
            } while ((missed = dw.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty2, Subscriber<? super Subject<T, T>> a, Queue<Subject<T, T>> q) {
            if (a.isUnsubscribed()) {
                q.clear();
                return true;
            }
            if (d) {
                Throwable e2 = this.error;
                if (e2 != null) {
                    q.clear();
                    a.onError(e2);
                    return true;
                }
                if (empty2) {
                    a.onCompleted();
                    return true;
                }
            }
            return false;
        }

        final class WindowOverlapProducer
        extends AtomicBoolean
        implements Producer {
            private static final long serialVersionUID = 4625807964358024108L;

            WindowOverlapProducer() {
            }

            @Override
            public void request(long n) {
                if (n < 0L) {
                    throw new IllegalArgumentException("n >= 0 required but it was " + n);
                }
                if (n != 0L) {
                    WindowOverlap parent = WindowOverlap.this;
                    if (!this.get() && this.compareAndSet(false, true)) {
                        long u = BackpressureUtils.multiplyCap(parent.skip, n - 1L);
                        long v = BackpressureUtils.addCap(u, parent.size);
                        parent.request(v);
                    } else {
                        long u = BackpressureUtils.multiplyCap(parent.skip, n);
                        WindowOverlap.this.request(u);
                    }
                    BackpressureUtils.getAndAddRequest(parent.requested, n);
                    parent.drain();
                }
            }
        }
    }

    static final class WindowSkip<T>
    extends Subscriber<T>
    implements Action0 {
        final Subscriber<? super Observable<T>> actual;
        final int size;
        final int skip;
        final AtomicInteger wip;
        final Subscription cancel;
        int index;
        Subject<T, T> window;

        public WindowSkip(Subscriber<? super Observable<T>> actual, int size, int skip) {
            this.actual = actual;
            this.size = size;
            this.skip = skip;
            this.wip = new AtomicInteger(1);
            this.cancel = Subscriptions.create(this);
            this.add(this.cancel);
            this.request(0L);
        }

        @Override
        public void onNext(T t) {
            int i = this.index;
            Subject<T, T> w = this.window;
            if (i == 0) {
                this.wip.getAndIncrement();
                w = UnicastSubject.create(this.size, this);
                this.window = w;
                this.actual.onNext(w);
            }
            ++i;
            if (w != null) {
                w.onNext(t);
            }
            if (i == this.size) {
                this.index = i;
                this.window = null;
                w.onCompleted();
            } else {
                this.index = i == this.skip ? 0 : i;
            }
        }

        @Override
        public void onError(Throwable e2) {
            Subject<T, T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(e2);
            }
            this.actual.onError(e2);
        }

        @Override
        public void onCompleted() {
            Subject<T, T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onCompleted();
            }
            this.actual.onCompleted();
        }

        Producer createProducer() {
            return new WindowSkipProducer();
        }

        @Override
        public void call() {
            if (this.wip.decrementAndGet() == 0) {
                this.unsubscribe();
            }
        }

        final class WindowSkipProducer
        extends AtomicBoolean
        implements Producer {
            private static final long serialVersionUID = 4625807964358024108L;

            WindowSkipProducer() {
            }

            @Override
            public void request(long n) {
                if (n < 0L) {
                    throw new IllegalArgumentException("n >= 0 required but it was " + n);
                }
                if (n != 0L) {
                    WindowSkip parent = WindowSkip.this;
                    if (!this.get() && this.compareAndSet(false, true)) {
                        long u = BackpressureUtils.multiplyCap(n, parent.size);
                        long v = BackpressureUtils.multiplyCap(parent.skip - parent.size, n - 1L);
                        long w = BackpressureUtils.addCap(u, v);
                        parent.request(w);
                    } else {
                        long u = BackpressureUtils.multiplyCap(n, parent.skip);
                        parent.request(u);
                    }
                }
            }
        }
    }

    static final class WindowExact<T>
    extends Subscriber<T>
    implements Action0 {
        final Subscriber<? super Observable<T>> actual;
        final int size;
        final AtomicInteger wip;
        final Subscription cancel;
        int index;
        Subject<T, T> window;

        public WindowExact(Subscriber<? super Observable<T>> actual, int size) {
            this.actual = actual;
            this.size = size;
            this.wip = new AtomicInteger(1);
            this.cancel = Subscriptions.create(this);
            this.add(this.cancel);
            this.request(0L);
        }

        @Override
        public void onNext(T t) {
            int i = this.index;
            Subject<T, T> w = this.window;
            if (i == 0) {
                this.wip.getAndIncrement();
                w = UnicastSubject.create(this.size, this);
                this.window = w;
                this.actual.onNext(w);
            }
            w.onNext(t);
            if (++i == this.size) {
                this.index = 0;
                this.window = null;
                w.onCompleted();
            } else {
                this.index = i;
            }
        }

        @Override
        public void onError(Throwable e2) {
            Subject<T, T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onError(e2);
            }
            this.actual.onError(e2);
        }

        @Override
        public void onCompleted() {
            Subject<T, T> w = this.window;
            if (w != null) {
                this.window = null;
                w.onCompleted();
            }
            this.actual.onCompleted();
        }

        Producer createProducer() {
            return new Producer(){

                @Override
                public void request(long n) {
                    if (n < 0L) {
                        throw new IllegalArgumentException("n >= 0 required but it was " + n);
                    }
                    if (n != 0L) {
                        long u = BackpressureUtils.multiplyCap(WindowExact.this.size, n);
                        WindowExact.this.request(u);
                    }
                }
            };
        }

        @Override
        public void call() {
            if (this.wip.decrementAndGet() == 0) {
                this.unsubscribe();
            }
        }
    }
}

