/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Observer;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.functions.Func0;
import io.mantisrx.mql.shaded.rx.internal.operators.NotificationLite;
import io.mantisrx.mql.shaded.rx.observers.SerializedSubscriber;
import io.mantisrx.mql.shaded.rx.subjects.UnicastSubject;
import io.mantisrx.mql.shaded.rx.subscriptions.SerialSubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OperatorWindowWithObservableFactory<T, U>
implements Observable.Operator<Observable<T>, T> {
    final Func0<? extends Observable<? extends U>> otherFactory;
    static final Object NEXT_SUBJECT = new Object();

    public OperatorWindowWithObservableFactory(Func0<? extends Observable<? extends U>> otherFactory) {
        this.otherFactory = otherFactory;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super Observable<T>> child) {
        SourceSubscriber sub = new SourceSubscriber(child, this.otherFactory);
        child.add(sub);
        sub.replaceWindow();
        return sub;
    }

    static final class BoundarySubscriber<T, U>
    extends Subscriber<U> {
        final SourceSubscriber<T, U> sub;
        boolean done;

        public BoundarySubscriber(SourceSubscriber<T, U> sub) {
            this.sub = sub;
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(U t) {
            if (!this.done) {
                this.done = true;
                this.sub.replaceWindow();
            }
        }

        @Override
        public void onError(Throwable e2) {
            this.sub.onError(e2);
        }

        @Override
        public void onCompleted() {
            if (!this.done) {
                this.done = true;
                this.sub.onCompleted();
            }
        }
    }

    static final class SourceSubscriber<T, U>
    extends Subscriber<T> {
        final Subscriber<? super Observable<T>> child;
        final Object guard;
        Observer<T> consumer;
        Observable<T> producer;
        boolean emitting;
        List<Object> queue;
        final SerialSubscription serial;
        final Func0<? extends Observable<? extends U>> otherFactory;

        public SourceSubscriber(Subscriber<? super Observable<T>> child, Func0<? extends Observable<? extends U>> otherFactory) {
            this.child = new SerializedSubscriber<Observable<? super Observable<T>>>(child);
            this.guard = new Object();
            this.serial = new SerialSubscription();
            this.otherFactory = otherFactory;
            this.add(this.serial);
        }

        @Override
        public void onStart() {
            this.request(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onNext(T t) {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(t);
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            boolean once = true;
            boolean skipFinal = false;
            try {
                do {
                    this.drain(localQueue);
                    if (once) {
                        once = false;
                        this.emitValue(t);
                    }
                    Object object2 = this.guard;
                    synchronized (object2) {
                        localQueue = this.queue;
                        this.queue = null;
                        if (localQueue == null) {
                            this.emitting = false;
                            skipFinal = true;
                            return;
                        }
                    }
                } while (!this.child.isUnsubscribed());
                return;
            }
            finally {
                if (!skipFinal) {
                    Object object3 = this.guard;
                    synchronized (object3) {
                        this.emitting = false;
                    }
                }
            }
        }

        void drain(List<Object> queue) {
            if (queue == null) {
                return;
            }
            for (Object o : queue) {
                if (o == NEXT_SUBJECT) {
                    this.replaceSubject();
                    continue;
                }
                if (NotificationLite.isError(o)) {
                    this.error(NotificationLite.getError(o));
                    break;
                }
                if (NotificationLite.isCompleted(o)) {
                    this.complete();
                    break;
                }
                Object t = o;
                this.emitValue(t);
            }
        }

        void replaceSubject() {
            Observer<T> s = this.consumer;
            if (s != null) {
                s.onCompleted();
            }
            this.createNewWindow();
            this.child.onNext(this.producer);
        }

        void createNewWindow() {
            Observable<U> other;
            UnicastSubject bus = UnicastSubject.create();
            this.consumer = bus;
            this.producer = bus;
            try {
                other = this.otherFactory.call();
            }
            catch (Throwable e2) {
                this.child.onError(e2);
                this.unsubscribe();
                return;
            }
            BoundarySubscriber bs = new BoundarySubscriber(this);
            this.serial.set(bs);
            other.unsafeSubscribe(bs);
        }

        void emitValue(T t) {
            Observer<T> s = this.consumer;
            if (s != null) {
                s.onNext(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e2) {
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    this.queue = Collections.singletonList(NotificationLite.error(e2));
                    return;
                }
                this.queue = null;
                this.emitting = true;
            }
            this.error(e2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(NotificationLite.completed());
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            try {
                this.drain(localQueue);
            }
            catch (Throwable e2) {
                this.error(e2);
                return;
            }
            this.complete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void replaceWindow() {
            List<Object> localQueue;
            Object object = this.guard;
            synchronized (object) {
                if (this.emitting) {
                    if (this.queue == null) {
                        this.queue = new ArrayList<Object>();
                    }
                    this.queue.add(NEXT_SUBJECT);
                    return;
                }
                localQueue = this.queue;
                this.queue = null;
                this.emitting = true;
            }
            boolean once = true;
            boolean skipFinal = false;
            try {
                do {
                    this.drain(localQueue);
                    if (once) {
                        once = false;
                        this.replaceSubject();
                    }
                    Object object2 = this.guard;
                    synchronized (object2) {
                        localQueue = this.queue;
                        this.queue = null;
                        if (localQueue == null) {
                            this.emitting = false;
                            skipFinal = true;
                            return;
                        }
                    }
                } while (!this.child.isUnsubscribed());
                return;
            }
            finally {
                if (!skipFinal) {
                    Object object3 = this.guard;
                    synchronized (object3) {
                        this.emitting = false;
                    }
                }
            }
        }

        void complete() {
            Observer<T> s = this.consumer;
            this.consumer = null;
            this.producer = null;
            if (s != null) {
                s.onCompleted();
            }
            this.child.onCompleted();
            this.unsubscribe();
        }

        void error(Throwable e2) {
            Observer<T> s = this.consumer;
            this.consumer = null;
            this.producer = null;
            if (s != null) {
                s.onError(e2);
            }
            this.child.onError(e2);
            this.unsubscribe();
        }
    }
}

