/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.Func1;
import io.mantisrx.mql.shaded.rx.functions.Func2;

public final class OperatorTakeWhile<T>
implements Observable.Operator<T, T> {
    final Func2<? super T, ? super Integer, Boolean> predicate;

    public OperatorTakeWhile(final Func1<? super T, Boolean> underlying) {
        this(new Func2<T, Integer, Boolean>(){

            @Override
            public Boolean call(T input, Integer index2) {
                return (Boolean)underlying.call(input);
            }
        });
    }

    public OperatorTakeWhile(Func2<? super T, ? super Integer, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> subscriber2) {
        Subscriber s = new Subscriber<T>(subscriber2, false){
            private int counter;
            private boolean done;

            @Override
            public void onNext(T t) {
                boolean isSelected;
                try {
                    isSelected = OperatorTakeWhile.this.predicate.call(t, this.counter++);
                }
                catch (Throwable e2) {
                    this.done = true;
                    Exceptions.throwOrReport(e2, subscriber2, t);
                    this.unsubscribe();
                    return;
                }
                if (isSelected) {
                    subscriber2.onNext(t);
                } else {
                    this.done = true;
                    subscriber2.onCompleted();
                    this.unsubscribe();
                }
            }

            @Override
            public void onCompleted() {
                if (!this.done) {
                    subscriber2.onCompleted();
                }
            }

            @Override
            public void onError(Throwable e2) {
                if (!this.done) {
                    subscriber2.onError(e2);
                }
            }
        };
        subscriber2.add(s);
        return s;
    }
}

