/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.observers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;

public final class OperatorSkipUntil<T, U>
implements Observable.Operator<T, T> {
    final Observable<U> other;

    public OperatorSkipUntil(Observable<U> other) {
        this.other = other;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        final AtomicBoolean gate = new AtomicBoolean();
        Subscriber u = new Subscriber<U>(){

            @Override
            public void onNext(U t) {
                gate.set(true);
                this.unsubscribe();
            }

            @Override
            public void onError(Throwable e2) {
                s.onError(e2);
                s.unsubscribe();
            }

            @Override
            public void onCompleted() {
                this.unsubscribe();
            }
        };
        child.add(u);
        this.other.unsafeSubscribe(u);
        return new Subscriber<T>(child){

            @Override
            public void onNext(T t) {
                if (gate.get()) {
                    s.onNext(t);
                } else {
                    this.request(1L);
                }
            }

            @Override
            public void onError(Throwable e2) {
                s.onError(e2);
                this.unsubscribe();
            }

            @Override
            public void onCompleted() {
                s.onCompleted();
                this.unsubscribe();
            }
        };
    }
}

