/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.internal.producers.SingleProducer;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import java.util.NoSuchElementException;

public final class OperatorSingle<T>
implements Observable.Operator<T, T> {
    private final boolean hasDefaultValue;
    private final T defaultValue;

    public static <T> OperatorSingle<T> instance() {
        return Holder.INSTANCE;
    }

    OperatorSingle() {
        this(false, null);
    }

    public OperatorSingle(T defaultValue) {
        this(true, defaultValue);
    }

    private OperatorSingle(boolean hasDefaultValue, T defaultValue) {
        this.hasDefaultValue = hasDefaultValue;
        this.defaultValue = defaultValue;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        ParentSubscriber<? super T> parent = new ParentSubscriber<T>(child, this.hasDefaultValue, this.defaultValue);
        child.add(parent);
        return parent;
    }

    static final class ParentSubscriber<T>
    extends Subscriber<T> {
        private final Subscriber<? super T> child;
        private final boolean hasDefaultValue;
        private final T defaultValue;
        private T value;
        private boolean isNonEmpty;
        private boolean hasTooManyElements;

        ParentSubscriber(Subscriber<? super T> child, boolean hasDefaultValue, T defaultValue) {
            this.child = child;
            this.hasDefaultValue = hasDefaultValue;
            this.defaultValue = defaultValue;
            this.request(2L);
        }

        @Override
        public void onNext(T value) {
            if (!this.hasTooManyElements) {
                if (this.isNonEmpty) {
                    this.hasTooManyElements = true;
                    this.child.onError(new IllegalArgumentException("Sequence contains too many elements"));
                    this.unsubscribe();
                } else {
                    this.value = value;
                    this.isNonEmpty = true;
                }
            }
        }

        @Override
        public void onCompleted() {
            if (!this.hasTooManyElements) {
                if (this.isNonEmpty) {
                    this.child.setProducer(new SingleProducer<T>(this.child, this.value));
                } else if (this.hasDefaultValue) {
                    this.child.setProducer(new SingleProducer<T>(this.child, this.defaultValue));
                } else {
                    this.child.onError(new NoSuchElementException("Sequence contains no elements"));
                }
            }
        }

        @Override
        public void onError(Throwable e2) {
            if (this.hasTooManyElements) {
                RxJavaHooks.onError(e2);
                return;
            }
            this.child.onError(e2);
        }
    }

    static final class Holder {
        static final OperatorSingle<?> INSTANCE = new OperatorSingle();

        Holder() {
        }
    }
}

