/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.functions.Action1;
import io.mantisrx.mql.shaded.rx.functions.Func1;
import io.mantisrx.mql.shaded.rx.internal.operators.BackpressureUtils;
import io.mantisrx.mql.shaded.rx.internal.operators.NotificationLite;
import io.mantisrx.mql.shaded.rx.internal.producers.ProducerArbiter;
import io.mantisrx.mql.shaded.rx.internal.util.RxRingBuffer;
import io.mantisrx.mql.shaded.rx.internal.util.UtilityFunctions;
import io.mantisrx.mql.shaded.rx.observables.GroupedObservable;
import io.mantisrx.mql.shaded.rx.observers.Subscribers;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import io.mantisrx.mql.shaded.rx.subscriptions.Subscriptions;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class OperatorGroupByEvicting<T, K, V>
implements Observable.Operator<GroupedObservable<K, V>, T> {
    final Func1<? super T, ? extends K> keySelector;
    final Func1<? super T, ? extends V> valueSelector;
    final int bufferSize;
    final boolean delayError;
    final Func1<Action1<Object>, Map<K, Object>> mapFactory;

    public OperatorGroupByEvicting(Func1<? super T, ? extends K> keySelector) {
        this(keySelector, UtilityFunctions.identity(), RxRingBuffer.SIZE, false, null);
    }

    public OperatorGroupByEvicting(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector) {
        this(keySelector, valueSelector, RxRingBuffer.SIZE, false, null);
    }

    public OperatorGroupByEvicting(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError, Func1<Action1<Object>, Map<K, Object>> mapFactory) {
        this.keySelector = keySelector;
        this.valueSelector = valueSelector;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
        this.mapFactory = mapFactory;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super GroupedObservable<K, V>> child) {
        Map groups;
        ConcurrentLinkedQueue evictedGroups;
        if (this.mapFactory == null) {
            evictedGroups = null;
            groups = new ConcurrentHashMap();
        } else {
            evictedGroups = new ConcurrentLinkedQueue();
            EvictionAction evictionAction = new EvictionAction(evictedGroups);
            try {
                groups = this.mapFactory.call(evictionAction);
            }
            catch (Throwable ex) {
                Exceptions.throwOrReport(ex, child);
                Subscriber parent2 = Subscribers.empty();
                parent2.unsubscribe();
                return parent2;
            }
        }
        final GroupBySubscriber<? super T, ? extends K, ? extends V> parent = new GroupBySubscriber<T, K, V>(child, this.keySelector, this.valueSelector, this.bufferSize, this.delayError, groups, evictedGroups);
        child.add(Subscriptions.create(new Action0(){

            @Override
            public void call() {
                parent.cancel();
            }
        }));
        child.setProducer(parent.producer);
        return parent;
    }

    static final class State<T, K>
    extends AtomicInteger
    implements Producer,
    Subscription,
    Observable.OnSubscribe<T> {
        private static final long serialVersionUID = -3852313036005250360L;
        final K key;
        final Queue<Object> queue = new ConcurrentLinkedQueue<Object>();
        final GroupBySubscriber<?, K, T> parent;
        final boolean delayError;
        final AtomicLong requested;
        volatile boolean done;
        Throwable error;
        final AtomicBoolean cancelled;
        final AtomicReference<Subscriber<? super T>> actual;
        final AtomicBoolean once;

        public State(int bufferSize, GroupBySubscriber<?, K, T> parent, K key2, boolean delayError) {
            this.parent = parent;
            this.key = key2;
            this.delayError = delayError;
            this.cancelled = new AtomicBoolean();
            this.actual = new AtomicReference();
            this.once = new AtomicBoolean();
            this.requested = new AtomicLong();
        }

        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= required but it was " + n);
            }
            if (n != 0L) {
                BackpressureUtils.getAndAddRequest(this.requested, n);
                this.drain();
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.cancelled.get();
        }

        @Override
        public void unsubscribe() {
            if (this.cancelled.compareAndSet(false, true) && this.getAndIncrement() == 0) {
                this.parent.cancel(this.key);
            }
        }

        @Override
        public void call(Subscriber<? super T> s) {
            if (this.once.compareAndSet(false, true)) {
                s.add(this);
                s.setProducer(this);
                this.actual.lazySet(s);
                this.drain();
            } else {
                s.onError(new IllegalStateException("Only one Subscriber allowed!"));
            }
        }

        public void onNext(T t) {
            if (t == null) {
                this.error = new NullPointerException();
                this.done = true;
            } else {
                this.queue.offer(NotificationLite.next(t));
            }
            this.drain();
        }

        public void onError(Throwable e2) {
            this.error = e2;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Queue<Object> q = this.queue;
            boolean delayError = this.delayError;
            Subscriber a = this.actual.get();
            while (true) {
                if (a != null) {
                    if (this.checkTerminated(this.done, q.isEmpty(), a, delayError)) {
                        return;
                    }
                    long r = this.requested.get();
                    boolean unbounded = r == Long.MAX_VALUE;
                    long e2 = 0L;
                    while (r != 0L) {
                        boolean empty2;
                        boolean d = this.done;
                        Object v = q.poll();
                        boolean bl = empty2 = v == null;
                        if (this.checkTerminated(d, empty2, a, delayError)) {
                            return;
                        }
                        if (empty2) break;
                        a.onNext(NotificationLite.getValue(v));
                        --r;
                        --e2;
                    }
                    if (e2 != 0L) {
                        if (!unbounded) {
                            this.requested.addAndGet(e2);
                        }
                        this.parent.s.request(-e2);
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (a != null) continue;
                a = this.actual.get();
            }
        }

        boolean checkTerminated(boolean d, boolean empty2, Subscriber<? super T> a, boolean delayError) {
            if (this.cancelled.get()) {
                this.queue.clear();
                this.parent.cancel(this.key);
                return true;
            }
            if (d) {
                if (delayError) {
                    if (empty2) {
                        Throwable e2 = this.error;
                        if (e2 != null) {
                            a.onError(e2);
                        } else {
                            a.onCompleted();
                        }
                        return true;
                    }
                } else {
                    Throwable e3 = this.error;
                    if (e3 != null) {
                        this.queue.clear();
                        a.onError(e3);
                        return true;
                    }
                    if (empty2) {
                        a.onCompleted();
                        return true;
                    }
                }
            }
            return false;
        }
    }

    static final class GroupedUnicast<K, T>
    extends GroupedObservable<K, T> {
        final State<T, K> state;

        public static <T, K> GroupedUnicast<K, T> createWith(K key2, int bufferSize, GroupBySubscriber<?, K, T> parent, boolean delayError) {
            State<T, K> state = new State<T, K>(bufferSize, parent, key2, delayError);
            return new GroupedUnicast<K, T>(key2, state);
        }

        protected GroupedUnicast(K key2, State<T, K> state) {
            super(key2, state);
            this.state = state;
        }

        public void onNext(T t) {
            this.state.onNext(t);
        }

        public void onError(Throwable e2) {
            this.state.onError(e2);
        }

        public void onComplete() {
            this.state.onComplete();
        }
    }

    static class EvictionAction<K, V>
    implements Action1<GroupedUnicast<K, V>> {
        final Queue<GroupedUnicast<K, V>> evictedGroups;

        EvictionAction(Queue<GroupedUnicast<K, V>> evictedGroups) {
            this.evictedGroups = evictedGroups;
        }

        @Override
        public void call(GroupedUnicast<K, V> group) {
            this.evictedGroups.offer(group);
        }
    }

    public static final class GroupBySubscriber<T, K, V>
    extends Subscriber<T> {
        final Subscriber<? super GroupedObservable<K, V>> actual;
        final Func1<? super T, ? extends K> keySelector;
        final Func1<? super T, ? extends V> valueSelector;
        final int bufferSize;
        final boolean delayError;
        final Map<K, GroupedUnicast<K, V>> groups;
        final Queue<GroupedUnicast<K, V>> queue;
        final GroupByProducer producer;
        final Queue<GroupedUnicast<K, V>> evictedGroups;
        static final Object NULL_KEY = new Object();
        final ProducerArbiter s;
        final AtomicBoolean cancelled;
        final AtomicLong requested;
        final AtomicInteger groupCount;
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip;

        public GroupBySubscriber(Subscriber<? super GroupedObservable<K, V>> actual, Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends V> valueSelector, int bufferSize, boolean delayError, Map<K, GroupedUnicast<K, V>> groups, Queue<GroupedUnicast<K, V>> evictedGroups) {
            this.actual = actual;
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            this.bufferSize = bufferSize;
            this.delayError = delayError;
            this.queue = new ConcurrentLinkedQueue<GroupedUnicast<K, V>>();
            this.s = new ProducerArbiter();
            this.s.request(bufferSize);
            this.producer = new GroupByProducer(this);
            this.cancelled = new AtomicBoolean();
            this.requested = new AtomicLong();
            this.groupCount = new AtomicInteger(1);
            this.wip = new AtomicInteger();
            this.groups = groups;
            this.evictedGroups = evictedGroups;
        }

        @Override
        public void setProducer(Producer s) {
            this.s.setProducer(s);
        }

        @Override
        public void onNext(T t) {
            V v;
            K key2;
            if (this.done) {
                return;
            }
            Queue<GroupedUnicast<K, V>> q = this.queue;
            Subscriber<? super GroupedObservable<K, V>> a = this.actual;
            try {
                key2 = this.keySelector.call(t);
            }
            catch (Throwable ex) {
                this.unsubscribe();
                this.errorAll(a, q, ex);
                return;
            }
            boolean newGroup = false;
            Object mapKey = key2 != null ? key2 : NULL_KEY;
            GroupedUnicast<K, Object> group = this.groups.get(mapKey);
            if (group == null) {
                if (!this.cancelled.get()) {
                    group = GroupedUnicast.createWith(key2, this.bufferSize, this, this.delayError);
                    this.groups.put(mapKey, group);
                    this.groupCount.getAndIncrement();
                    newGroup = false;
                    q.offer(group);
                    this.drain();
                } else {
                    return;
                }
            }
            try {
                v = this.valueSelector.call(t);
            }
            catch (Throwable ex) {
                this.unsubscribe();
                this.errorAll(a, q, ex);
                return;
            }
            group.onNext(v);
            if (this.evictedGroups != null) {
                GroupedUnicast<K, V> evictedGroup;
                while ((evictedGroup = this.evictedGroups.poll()) != null) {
                    evictedGroup.onComplete();
                }
            }
            if (newGroup) {
                q.offer(group);
                this.drain();
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaHooks.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.groupCount.decrementAndGet();
            this.drain();
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            for (GroupedUnicast<K, V> e2 : this.groups.values()) {
                e2.onComplete();
            }
            this.groups.clear();
            if (this.evictedGroups != null) {
                this.evictedGroups.clear();
            }
            this.done = true;
            this.groupCount.decrementAndGet();
            this.drain();
        }

        public void requestMore(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
            BackpressureUtils.getAndAddRequest(this.requested, n);
            this.drain();
        }

        public void cancel() {
            if (this.cancelled.compareAndSet(false, true) && this.groupCount.decrementAndGet() == 0) {
                this.unsubscribe();
            }
        }

        public void cancel(K key2) {
            Object mapKey;
            Object object = mapKey = key2 != null ? key2 : NULL_KEY;
            if (this.groups.remove(mapKey) != null && this.groupCount.decrementAndGet() == 0) {
                this.unsubscribe();
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Queue<GroupedUnicast<K, V>> q = this.queue;
            Subscriber<GroupedObservable<K, V>> a = this.actual;
            do {
                if (this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                long r = this.requested.get();
                boolean unbounded = r == Long.MAX_VALUE;
                long e2 = 0L;
                while (r != 0L) {
                    boolean empty2;
                    boolean d = this.done;
                    GroupedObservable t = q.poll();
                    boolean bl = empty2 = t == null;
                    if (this.checkTerminated(d, empty2, a, q)) {
                        return;
                    }
                    if (empty2) break;
                    a.onNext(t);
                    --r;
                    --e2;
                }
                if (e2 == 0L) continue;
                if (!unbounded) {
                    this.requested.addAndGet(e2);
                }
                this.s.request(-e2);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        void errorAll(Subscriber<? super GroupedObservable<K, V>> a, Queue<?> q, Throwable ex) {
            q.clear();
            ArrayList<GroupedUnicast<K, V>> list = new ArrayList<GroupedUnicast<K, V>>(this.groups.values());
            this.groups.clear();
            if (this.evictedGroups != null) {
                this.evictedGroups.clear();
            }
            for (GroupedUnicast groupedUnicast : list) {
                groupedUnicast.onError(ex);
            }
            a.onError(ex);
        }

        boolean checkTerminated(boolean d, boolean empty2, Subscriber<? super GroupedObservable<K, V>> a, Queue<?> q) {
            if (d) {
                Throwable err = this.error;
                if (err != null) {
                    this.errorAll(a, q, err);
                    return true;
                }
                if (empty2) {
                    this.actual.onCompleted();
                    return true;
                }
            }
            return false;
        }
    }

    public static final class GroupByProducer
    implements Producer {
        final GroupBySubscriber<?, ?, ?> parent;

        public GroupByProducer(GroupBySubscriber<?, ?, ?> parent) {
            this.parent = parent;
        }

        @Override
        public void request(long n) {
            this.parent.requestMore(n);
        }
    }
}

