/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.functions.Action1;

public class OperatorDoOnRequest<T>
implements Observable.Operator<T, T> {
    final Action1<? super Long> request;

    public OperatorDoOnRequest(Action1<? super Long> request) {
        this.request = request;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final ParentSubscriber<? super T> parent = new ParentSubscriber<T>(child);
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                OperatorDoOnRequest.this.request.call((Long)n);
                parent.requestMore(n);
            }
        });
        child.add(parent);
        return parent;
    }

    static final class ParentSubscriber<T>
    extends Subscriber<T> {
        private final Subscriber<? super T> child;

        ParentSubscriber(Subscriber<? super T> child) {
            this.child = child;
            this.request(0L);
        }

        private void requestMore(long n) {
            this.request(n);
        }

        @Override
        public void onCompleted() {
            this.child.onCompleted();
        }

        @Override
        public void onError(Throwable e2) {
            this.child.onError(e2);
        }

        @Override
        public void onNext(T t) {
            this.child.onNext(t);
        }
    }
}

