/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;

public final class OperatorDoAfterTerminate<T>
implements Observable.Operator<T, T> {
    final Action0 action;

    public OperatorDoAfterTerminate(Action0 action2) {
        if (action2 == null) {
            throw new NullPointerException("Action can not be null");
        }
        this.action = action2;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        return new Subscriber<T>(child){

            @Override
            public void onNext(T t) {
                child.onNext(t);
            }

            @Override
            public void onError(Throwable e2) {
                try {
                    child.onError(e2);
                }
                finally {
                    this.callAction();
                }
            }

            @Override
            public void onCompleted() {
                try {
                    child.onCompleted();
                }
                finally {
                    this.callAction();
                }
            }

            void callAction() {
                try {
                    OperatorDoAfterTerminate.this.action.call();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaHooks.onError(ex);
                }
            }
        };
    }
}

