/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Scheduler;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.internal.producers.ProducerArbiter;
import io.mantisrx.mql.shaded.rx.internal.subscriptions.SequentialSubscription;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public final class OnSubscribeTimeoutTimedWithFallback<T>
implements Observable.OnSubscribe<T> {
    final Observable<T> source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Observable<? extends T> fallback;

    public OnSubscribeTimeoutTimedWithFallback(Observable<T> source2, long timeout, TimeUnit unit, Scheduler scheduler, Observable<? extends T> fallback) {
        this.source = source2;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.fallback = fallback;
    }

    @Override
    public void call(Subscriber<? super T> t) {
        TimeoutMainSubscriber<T> parent = new TimeoutMainSubscriber<T>(t, this.timeout, this.unit, this.scheduler.createWorker(), this.fallback);
        t.add(parent.upstream);
        t.setProducer(parent.arbiter);
        parent.startTimeout(0L);
        this.source.subscribe((Subscriber<? extends T>)parent);
    }

    static final class FallbackSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final ProducerArbiter arbiter;

        FallbackSubscriber(Subscriber<? super T> actual, ProducerArbiter arbiter) {
            this.actual = actual;
            this.arbiter = arbiter;
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable e2) {
            this.actual.onError(e2);
        }

        @Override
        public void onCompleted() {
            this.actual.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            this.arbiter.setProducer(p);
        }
    }

    static final class TimeoutMainSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final Observable<? extends T> fallback;
        final ProducerArbiter arbiter;
        final AtomicLong index;
        final SequentialSubscription task;
        final SequentialSubscription upstream;
        long consumed;

        TimeoutMainSubscriber(Subscriber<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker, Observable<? extends T> fallback) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.fallback = fallback;
            this.arbiter = new ProducerArbiter();
            this.index = new AtomicLong();
            this.task = new SequentialSubscription();
            this.upstream = new SequentialSubscription(this);
            this.add(worker);
            this.add(this.task);
        }

        @Override
        public void onNext(T t) {
            long idx = this.index.get();
            if (idx == Long.MAX_VALUE || !this.index.compareAndSet(idx, idx + 1L)) {
                return;
            }
            Subscription s = (Subscription)this.task.get();
            if (s != null) {
                s.unsubscribe();
            }
            ++this.consumed;
            this.actual.onNext(t);
            this.startTimeout(idx + 1L);
        }

        void startTimeout(long nextIdx) {
            this.task.replace(this.worker.schedule(new TimeoutTask(nextIdx), this.timeout, this.unit));
        }

        @Override
        public void onError(Throwable e2) {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.unsubscribe();
                this.actual.onError(e2);
                this.worker.unsubscribe();
            } else {
                RxJavaHooks.onError(e2);
            }
        }

        @Override
        public void onCompleted() {
            if (this.index.getAndSet(Long.MAX_VALUE) != Long.MAX_VALUE) {
                this.task.unsubscribe();
                this.actual.onCompleted();
                this.worker.unsubscribe();
            }
        }

        @Override
        public void setProducer(Producer p) {
            this.arbiter.setProducer(p);
        }

        void onTimeout(long idx) {
            if (!this.index.compareAndSet(idx, Long.MAX_VALUE)) {
                return;
            }
            this.unsubscribe();
            if (this.fallback == null) {
                this.actual.onError(new TimeoutException());
            } else {
                FallbackSubscriber<? super T> fallbackSubscriber;
                long c = this.consumed;
                if (c != 0L) {
                    this.arbiter.produced(c);
                }
                if (this.upstream.replace(fallbackSubscriber = new FallbackSubscriber<T>(this.actual, this.arbiter))) {
                    this.fallback.subscribe((Subscriber<? super T>)fallbackSubscriber);
                }
            }
        }

        final class TimeoutTask
        implements Action0 {
            final long idx;

            TimeoutTask(long idx) {
                this.idx = idx;
            }

            @Override
            public void call() {
                TimeoutMainSubscriber.this.onTimeout(this.idx);
            }
        }
    }
}

