/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.functions.Action1;
import io.mantisrx.mql.shaded.rx.observables.ConnectableObservable;
import io.mantisrx.mql.shaded.rx.subscriptions.CompositeSubscription;
import io.mantisrx.mql.shaded.rx.subscriptions.Subscriptions;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class OnSubscribeRefCount<T>
implements Observable.OnSubscribe<T> {
    private final ConnectableObservable<? extends T> source;
    volatile CompositeSubscription baseSubscription = new CompositeSubscription();
    final AtomicInteger subscriptionCount = new AtomicInteger(0);
    final ReentrantLock lock = new ReentrantLock();

    public OnSubscribeRefCount(ConnectableObservable<? extends T> source2) {
        this.source = source2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(Subscriber<? super T> subscriber2) {
        this.lock.lock();
        if (this.subscriptionCount.incrementAndGet() == 1) {
            AtomicBoolean writeLocked = new AtomicBoolean(true);
            try {
                this.source.connect(this.onSubscribe(subscriber2, writeLocked));
            }
            finally {
                if (writeLocked.get()) {
                    this.lock.unlock();
                }
            }
        }
        try {
            this.doSubscribe(subscriber2, this.baseSubscription);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Action1<Subscription> onSubscribe(final Subscriber<? super T> subscriber2, final AtomicBoolean writeLocked) {
        return new Action1<Subscription>(){

            @Override
            public void call(Subscription subscription2) {
                try {
                    OnSubscribeRefCount.this.baseSubscription.add(subscription2);
                    OnSubscribeRefCount.this.doSubscribe(subscriber2, OnSubscribeRefCount.this.baseSubscription);
                }
                finally {
                    OnSubscribeRefCount.this.lock.unlock();
                    writeLocked.set(false);
                }
            }
        };
    }

    void doSubscribe(final Subscriber<? super T> subscriber2, final CompositeSubscription currentBase) {
        subscriber2.add(this.disconnect(currentBase));
        this.source.unsafeSubscribe(new Subscriber<T>(subscriber2){

            @Override
            public void onError(Throwable e2) {
                this.cleanup();
                subscriber2.onError(e2);
            }

            @Override
            public void onNext(T t) {
                subscriber2.onNext(t);
            }

            @Override
            public void onCompleted() {
                this.cleanup();
                subscriber2.onCompleted();
            }

            void cleanup() {
                OnSubscribeRefCount.this.lock.lock();
                try {
                    if (OnSubscribeRefCount.this.baseSubscription == currentBase) {
                        if (OnSubscribeRefCount.this.source instanceof Subscription) {
                            ((Subscription)((Object)OnSubscribeRefCount.this.source)).unsubscribe();
                        }
                        OnSubscribeRefCount.this.baseSubscription.unsubscribe();
                        OnSubscribeRefCount.this.baseSubscription = new CompositeSubscription();
                        OnSubscribeRefCount.this.subscriptionCount.set(0);
                    }
                }
                finally {
                    OnSubscribeRefCount.this.lock.unlock();
                }
            }
        });
    }

    private Subscription disconnect(final CompositeSubscription current) {
        return Subscriptions.create(new Action0(){

            @Override
            public void call() {
                OnSubscribeRefCount.this.lock.lock();
                try {
                    if (OnSubscribeRefCount.this.baseSubscription == current && OnSubscribeRefCount.this.subscriptionCount.decrementAndGet() == 0) {
                        if (OnSubscribeRefCount.this.source instanceof Subscription) {
                            ((Subscription)((Object)OnSubscribeRefCount.this.source)).unsubscribe();
                        }
                        OnSubscribeRefCount.this.baseSubscription.unsubscribe();
                        OnSubscribeRefCount.this.baseSubscription = new CompositeSubscription();
                    }
                }
                finally {
                    OnSubscribeRefCount.this.lock.unlock();
                }
            }
        });
    }
}

