/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Notification;
import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Scheduler;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.functions.Action0;
import io.mantisrx.mql.shaded.rx.functions.Func1;
import io.mantisrx.mql.shaded.rx.functions.Func2;
import io.mantisrx.mql.shaded.rx.internal.operators.BackpressureUtils;
import io.mantisrx.mql.shaded.rx.internal.producers.ProducerArbiter;
import io.mantisrx.mql.shaded.rx.observers.Subscribers;
import io.mantisrx.mql.shaded.rx.schedulers.Schedulers;
import io.mantisrx.mql.shaded.rx.subjects.BehaviorSubject;
import io.mantisrx.mql.shaded.rx.subjects.SerializedSubject;
import io.mantisrx.mql.shaded.rx.subscriptions.SerialSubscription;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class OnSubscribeRedo<T>
implements Observable.OnSubscribe<T> {
    final Observable<T> source;
    private final Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> controlHandlerFunction;
    final boolean stopOnComplete;
    final boolean stopOnError;
    private final Scheduler scheduler;
    static final Func1<Observable<? extends Notification<?>>, Observable<?>> REDO_INFINITE = new Func1<Observable<? extends Notification<?>>, Observable<?>>(){

        @Override
        public Observable<?> call(Observable<? extends Notification<?>> ts) {
            return ts.map(new Func1<Notification<?>, Notification<?>>(){

                @Override
                public Notification<?> call(Notification<?> terminal) {
                    return Notification.createOnNext(null);
                }
            });
        }
    };

    public static <T> Observable<T> retry(Observable<T> source2) {
        return OnSubscribeRedo.retry(source2, REDO_INFINITE);
    }

    public static <T> Observable<T> retry(Observable<T> source2, long count2) {
        if (count2 < 0L) {
            throw new IllegalArgumentException("count >= 0 expected");
        }
        if (count2 == 0L) {
            return source2;
        }
        return OnSubscribeRedo.retry(source2, new RedoFinite(count2));
    }

    public static <T> Observable<T> retry(Observable<T> source2, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler) {
        return Observable.unsafeCreate(new OnSubscribeRedo<T>(source2, notificationHandler, true, false, Schedulers.trampoline()));
    }

    public static <T> Observable<T> retry(Observable<T> source2, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler, Scheduler scheduler) {
        return Observable.unsafeCreate(new OnSubscribeRedo<T>(source2, notificationHandler, true, false, scheduler));
    }

    public static <T> Observable<T> repeat(Observable<T> source2) {
        return OnSubscribeRedo.repeat(source2, Schedulers.trampoline());
    }

    public static <T> Observable<T> repeat(Observable<T> source2, Scheduler scheduler) {
        return OnSubscribeRedo.repeat(source2, REDO_INFINITE, scheduler);
    }

    public static <T> Observable<T> repeat(Observable<T> source2, long count2) {
        return OnSubscribeRedo.repeat(source2, count2, Schedulers.trampoline());
    }

    public static <T> Observable<T> repeat(Observable<T> source2, long count2, Scheduler scheduler) {
        if (count2 == 0L) {
            return Observable.empty();
        }
        if (count2 < 0L) {
            throw new IllegalArgumentException("count >= 0 expected");
        }
        return OnSubscribeRedo.repeat(source2, new RedoFinite(count2 - 1L), scheduler);
    }

    public static <T> Observable<T> repeat(Observable<T> source2, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler) {
        return Observable.unsafeCreate(new OnSubscribeRedo<T>(source2, notificationHandler, false, true, Schedulers.trampoline()));
    }

    public static <T> Observable<T> repeat(Observable<T> source2, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler, Scheduler scheduler) {
        return Observable.unsafeCreate(new OnSubscribeRedo<T>(source2, notificationHandler, false, true, scheduler));
    }

    public static <T> Observable<T> redo(Observable<T> source2, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> notificationHandler, Scheduler scheduler) {
        return Observable.unsafeCreate(new OnSubscribeRedo<T>(source2, notificationHandler, false, false, scheduler));
    }

    private OnSubscribeRedo(Observable<T> source2, Func1<? super Observable<? extends Notification<?>>, ? extends Observable<?>> f, boolean stopOnComplete, boolean stopOnError, Scheduler scheduler) {
        this.source = source2;
        this.controlHandlerFunction = f;
        this.stopOnComplete = stopOnComplete;
        this.stopOnError = stopOnError;
        this.scheduler = scheduler;
    }

    @Override
    public void call(final Subscriber<? super T> child) {
        final AtomicBoolean resumeBoundary = new AtomicBoolean(true);
        final AtomicLong consumerCapacity = new AtomicLong();
        final Scheduler.Worker worker = this.scheduler.createWorker();
        child.add(worker);
        final SerialSubscription sourceSubscriptions = new SerialSubscription();
        child.add(sourceSubscriptions);
        final SerializedSubject terminals = BehaviorSubject.create().toSerialized();
        Subscriber dummySubscriber = Subscribers.empty();
        terminals.subscribe(dummySubscriber);
        final ProducerArbiter arbiter = new ProducerArbiter();
        final Action0 subscribeToSource = new Action0(){

            @Override
            public void call() {
                if (child.isUnsubscribed()) {
                    return;
                }
                Subscriber terminalDelegatingSubscriber = new Subscriber<T>(){
                    boolean done;

                    @Override
                    public void onCompleted() {
                        if (!this.done) {
                            this.done = true;
                            this.unsubscribe();
                            terminals.onNext(Notification.createOnCompleted());
                        }
                    }

                    @Override
                    public void onError(Throwable e2) {
                        if (!this.done) {
                            this.done = true;
                            this.unsubscribe();
                            terminals.onNext(Notification.createOnError(e2));
                        }
                    }

                    @Override
                    public void onNext(T v) {
                        if (!this.done) {
                            child.onNext(v);
                            this.decrementConsumerCapacity();
                            arbiter.produced(1L);
                        }
                    }

                    private void decrementConsumerCapacity() {
                        long cc;
                        while ((cc = consumerCapacity.get()) != Long.MAX_VALUE && !consumerCapacity.compareAndSet(cc, cc - 1L)) {
                        }
                    }

                    @Override
                    public void setProducer(Producer producer) {
                        arbiter.setProducer(producer);
                    }
                };
                sourceSubscriptions.set(terminalDelegatingSubscriber);
                OnSubscribeRedo.this.source.unsafeSubscribe(terminalDelegatingSubscriber);
            }
        };
        final Observable<?> restarts = this.controlHandlerFunction.call(terminals.lift(new Observable.Operator<Notification<?>, Notification<?>>(){

            @Override
            public Subscriber<? super Notification<?>> call(final Subscriber<? super Notification<?>> filteredTerminals) {
                return new Subscriber<Notification<?>>(filteredTerminals){

                    @Override
                    public void onCompleted() {
                        filteredTerminals.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e2) {
                        filteredTerminals.onError(e2);
                    }

                    @Override
                    public void onNext(Notification<?> t) {
                        if (t.isOnCompleted() && OnSubscribeRedo.this.stopOnComplete) {
                            filteredTerminals.onCompleted();
                        } else if (t.isOnError() && OnSubscribeRedo.this.stopOnError) {
                            filteredTerminals.onError(t.getThrowable());
                        } else {
                            filteredTerminals.onNext(t);
                        }
                    }

                    @Override
                    public void setProducer(Producer producer) {
                        producer.request(Long.MAX_VALUE);
                    }
                };
            }
        }));
        worker.schedule(new Action0(){

            @Override
            public void call() {
                restarts.unsafeSubscribe(new Subscriber<Object>(child){

                    @Override
                    public void onCompleted() {
                        child.onCompleted();
                    }

                    @Override
                    public void onError(Throwable e2) {
                        child.onError(e2);
                    }

                    @Override
                    public void onNext(Object t) {
                        if (!child.isUnsubscribed()) {
                            if (consumerCapacity.get() > 0L) {
                                worker.schedule(subscribeToSource);
                            } else {
                                resumeBoundary.compareAndSet(false, true);
                            }
                        }
                    }

                    @Override
                    public void setProducer(Producer producer) {
                        producer.request(Long.MAX_VALUE);
                    }
                });
            }
        });
        child.setProducer(new Producer(){

            @Override
            public void request(long n) {
                if (n > 0L) {
                    BackpressureUtils.getAndAddRequest(consumerCapacity, n);
                    arbiter.request(n);
                    if (resumeBoundary.compareAndSet(true, false)) {
                        worker.schedule(subscribeToSource);
                    }
                }
            }
        });
    }

    public static final class RetryWithPredicate
    implements Func1<Observable<? extends Notification<?>>, Observable<? extends Notification<?>>> {
        final Func2<Integer, Throwable, Boolean> predicate;

        public RetryWithPredicate(Func2<Integer, Throwable, Boolean> predicate) {
            this.predicate = predicate;
        }

        @Override
        public Observable<? extends Notification<?>> call(Observable<? extends Notification<?>> ts) {
            return ts.scan(Notification.createOnNext(0), new Func2<Notification<Integer>, Notification<?>, Notification<Integer>>(){

                @Override
                public Notification<Integer> call(Notification<Integer> n, Notification<?> term) {
                    int value = n.getValue();
                    if (RetryWithPredicate.this.predicate.call(value, term.getThrowable()).booleanValue()) {
                        return Notification.createOnNext(value + 1);
                    }
                    return term;
                }
            });
        }
    }

    public static final class RedoFinite
    implements Func1<Observable<? extends Notification<?>>, Observable<?>> {
        final long count;

        public RedoFinite(long count2) {
            this.count = count2;
        }

        @Override
        public Observable<?> call(Observable<? extends Notification<?>> ts) {
            return ts.map(new Func1<Notification<?>, Notification<?>>(){
                int num;

                @Override
                public Notification<?> call(Notification<?> terminalNotification) {
                    if (RedoFinite.this.count == 0L) {
                        return terminalNotification;
                    }
                    ++this.num;
                    if ((long)this.num <= RedoFinite.this.count) {
                        return Notification.createOnNext(this.num);
                    }
                    return terminalNotification;
                }
            }).dematerialize();
        }
    }
}

